/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.W;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class MathUtil {
    private static final RoundingMode ROUND = RoundingMode.HALF_UP;

    public static ThreadLocalRandom random() {
        return ThreadLocalRandom.current();
    }

    public static byte[] nextBytes(int len, int m, int n) {
        return MathUtil.nextBytes(MathUtil.random(), len, m, n);
    }

    public static byte[] nextBytes(Random r, int len, int m, int n) {
        return MathUtil.nextBytes(r, len, m, n, false);
    }

    public static byte[] nextBytes(Random r, int len, int s, int e, boolean is) {
        byte[] b = new byte[len];
        HashSet<Byte> set = W.S.newSet(len);
        for (int i = 0; i < len; ++i) {
            byte t = (byte)r.nextInt(s, e);
            if (!is && set.contains(t)) {
                --i;
                continue;
            }
            b[i] = t;
            set.add(b[i]);
        }
        set.clear();
        return b;
    }

    public static List<byte[]> nextBytes(Random r, int len, int s, int e, int n, boolean is) {
        if (s < -128) {
            s = -128;
        }
        if (e > 127) {
            e = 128;
        }
        List<byte[]> list = W.L.newList(n);
        for (int i = 0; i < n; ++i) {
            list.add(MathUtil.nextBytes(r, len, s, e, is));
        }
        return list;
    }

    public static List<byte[]> bytes(Random r, int len, int s, int e, int n) {
        List<byte[]> list = W.L.newList(n);
        for (int i = 0; i < n; ++i) {
            list.add(MathUtil.bytes(r, len, s, e));
        }
        return list;
    }

    public static byte[] bytes(Random r, int len, int s, int e) {
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            byte t = (byte)r.nextInt(s, e);
            boolean is = true;
            for (int j = 0; j < i; ++j) {
                if (b[j] != t) continue;
                --i;
                is = false;
                break;
            }
            if (!is) continue;
            b[i] = t;
        }
        return b;
    }

    public static int nextInt() {
        return MathUtil.random().nextInt();
    }

    public static int nextInt(int n) {
        return MathUtil.random().nextInt(n);
    }

    public static int nextInt(int m, int n) {
        return m > n ? 0 : MathUtil.nextInt(n - m) + m;
    }

    public static double nextDouble() {
        return MathUtil.random().nextDouble();
    }

    public static float nextFloat() {
        return MathUtil.random().nextFloat();
    }

    public static long nextLong() {
        return MathUtil.random().nextLong();
    }

    public static String random(int len) {
        StringBuilder veryfy = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int n = MathUtil.nextInt(48, 123);
            if (n > 91 && n < 97 || n > 57 && n < 65) {
                n += MathUtil.nextInt(7, 16);
            }
            veryfy.append((char)n);
        }
        return veryfy.toString();
    }

    public static BigDecimal add(Object ... values) {
        BigDecimal result = BigDecimal.ZERO;
        for (int i = 0; i < values.length; ++i) {
            result = result.add(W.C.toBigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal subtract(Object v1, Object v2) {
        return MathUtil.scale(v1).subtract(W.C.toBigDecimal(v2));
    }

    public static BigDecimal subtract(Object v1, Object v2, int scale) {
        return MathUtil.subtract(v1, v2).setScale(scale, ROUND);
    }

    public static BigDecimal multiply(Object ... values) {
        BigDecimal result = BigDecimal.ONE;
        for (int i = 0; i < values.length; ++i) {
            result = result.multiply(W.C.toBigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal divide(Object v1, Object v2) {
        return MathUtil.divide(v1, v2, 2);
    }

    public static BigDecimal divide(Object v1, Object v2, int scale) {
        return MathUtil.scale(v1, scale).divide(MathUtil.scale(v2, scale), scale, ROUND);
    }

    public static BigDecimal remainder(Object v1, Object v2) {
        return MathUtil.remainder(v1, v2, 2);
    }

    public static BigDecimal remainder(Object v1, Object v2, int scale) {
        return MathUtil.scale(v1, scale).remainder(MathUtil.scale(v2, scale));
    }

    public static BigDecimal scale(Object v) {
        return MathUtil.scale(v, 2);
    }

    public static BigDecimal scale(Object v, int scale) {
        return W.C.toBigDecimal(v).setScale(scale, ROUND);
    }

    public static String take(String v) {
        return v.indexOf(",") == -1 ? v : v.replaceAll(",", "");
    }

    public static String toString(Object val) {
        return W.C.toBigDecimal(val).toPlainString();
    }
}

