/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.U;
import java.util.regex.Pattern;

public class RegexUtil {
    public static boolean isLetters(String str) {
        return RegexUtil.is("^[a-zA-Z]+$", str);
    }

    public static boolean isCUQMobile(String str) {
        return RegexUtil.is("^(13[0-3]|15[36]|189)(\\d){8}$", str);
    }

    public static boolean isTELEMobile(String str) {
        return RegexUtil.is("^(133)(\\d){8}$", str);
    }

    public static boolean isRealName(String str) {
        return RegexUtil.is("^[a-zA-Z\u4e00-\u9fa5 .]+$", str);
    }

    public static boolean isPwd(String str) {
        return RegexUtil.is("^(\\w){6,20}$", str);
    }

    public static boolean isPassword(String str) {
        return RegexUtil.is("^[a-zA-Z0-9.!#$%&^*-_=+~?><]+$", str);
    }

    public static boolean isDate(String str) {
        return RegexUtil.is(new String[]{"^(\\d{4})(0[1-9]|1[0-2])(0[1-9]|1[0-9]|2[0-9]|3[0-1])$", "^(\\d{4})\\-(0[1-9]|1[0-2])\\-(0[1-9]|1[0-9]|2[0-9]|3[0-1])$", "^(\\d{4})\\-(0[1-9]|1[0-2])\\-(0[1-9]|1[0-9]|2[0-9]|3[0-1]) (0[0-9]|1[0-9]|2[0-4]):([0-5][0-9]):([0-5][0-9])$", "^(\\d{4})\\-(0[1-9]|1[0-2])\\-(0[1-9]|1[0-9]|2[0-9]|3[0-1]) (0[0-9]|1[0-9]|2[0-4]):([0-5][0-9])$", "^(\\d{4})(0[1-9]|1[0-2])(0[1-9]|1[0-9]|2[0-9]|3[0-1]) (0[0-9]|1[0-9]|2[0-4]):([0-5][0-9]):([0-5][0-9])$", "^(0[0-9]|1[0-9]|2[0-4]):([0-5][0-9]):([0-5][0-9])$"}, str);
    }

    public static boolean isEmail(String str) {
        return RegexUtil.is("^[\\w-]+(\\.[\\w-]+)*@[\\w-]+(\\.[\\w-]+)+$", str);
    }

    public static boolean isUserName(String str) {
        return RegexUtil.is("^[a-zA-Z]{1}[\\w]{3,17}$", str);
    }

    public static boolean isPhone(String str) {
        return RegexUtil.is("^[+]{0,1}(\\d){1,3}[   ]?([-]?((\\d)|[   ]){1,12})+$", str);
    }

    public static boolean isMobile(String str) {
        return RegexUtil.is("^(1[0-9][0-9])\\d{8}$", str);
    }

    public static boolean isPost(String str) {
        return RegexUtil.is("^[a-zA-Z0-9   ]{3,6}$", str);
    }

    public static boolean isIp(String str) {
        return RegexUtil.is("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$", str);
    }

    public static boolean isChinese(String str) {
        return RegexUtil.is("^[\\u4e00-\\u9fa5]*$", str);
    }

    public static boolean isURL(String str) {
        return RegexUtil.is("^[a-zA-z]+://(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*(\\?\\S*)?$", str);
    }

    public static boolean isDigit(String str) {
        return RegexUtil.is("^\\d+$", str);
    }

    public static boolean isNumber(String str) {
        return RegexUtil.is("^[0-9]*[1-9][0-9]*$", str);
    }

    public static boolean isIdentityCardNum(String str) {
        return RegexUtil.is("^[\\d]{15}|[\\d]{17}[\\dxX]{1}$", str);
    }

    public static boolean isChar(String str) {
        return RegexUtil.is("^[a-zA-Z0-9]$", str);
    }

    public static boolean isCharNumber(String str) {
        return RegexUtil.is("^([a-zA-Z0-9\u4e00-\u9fa5]|[_]|[ ]|[-]){1,100}$", str);
    }

    public static boolean is(String regex, String str) {
        return U.E.isEmpty(regex) || U.E.isEmpty(str) ? false : Pattern.compile(regex).matcher(str).matches();
    }

    public static boolean is(String[] regexs, String str) {
        if (U.E.isEmpty(regexs) || U.E.isEmpty(str)) {
            return false;
        }
        for (String regex : regexs) {
            if (!RegexUtil.is(regex, str)) continue;
            return true;
        }
        return false;
    }
}

