/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.RegexUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static boolean containsEmoji(String source) {
        int len = source.length();
        boolean isEmoji = false;
        for (int i = 0; i < len; ++i) {
            char hs = source.charAt(i);
            if ('\ud800' <= hs && hs <= '\udbff') {
                char ls;
                int uc;
                if (source.length() <= 1 || 118784 > (uc = (hs - 55296) * 1024 + ((ls = source.charAt(i + 1)) - 56320) + 65536) || uc > 128895) continue;
                return true;
            }
            if ('\u2100' <= hs && hs <= '\u27ff' && hs != '\u263b') {
                return true;
            }
            if ('\u2b05' <= hs && hs <= '\u2b07') {
                return true;
            }
            if ('\u2934' <= hs && hs <= '\u2935') {
                return true;
            }
            if ('\u3297' <= hs && hs <= '\u3299') {
                return true;
            }
            if (hs == '\u00a9' || hs == '\u00ae' || hs == '\u303d' || hs == '\u3030' || hs == '\u2b55' || hs == '\u2b1c' || hs == '\u2b1b' || hs == '\u2b50' || hs == '\u231a') {
                return true;
            }
            if (isEmoji || source.length() <= 1 || i >= source.length() - 1 || source.charAt(i + 1) != '\u20e3') continue;
            return true;
        }
        return isEmoji;
    }

    public static String filterEmoji(String source) {
        if (U.E.isEmpty(source)) {
            return source;
        }
        StringBuilder buf = null;
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (!StringUtil.isEmojiCharacter(codePoint)) continue;
            if (buf == null) {
                buf = new StringBuilder(source.length());
            }
            buf.append(codePoint);
        }
        if (buf == null) {
            return source;
        }
        if (buf.length() == len) {
            buf = null;
            return source;
        }
        return buf.toString();
    }

    public static boolean isEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static boolean startsWith(String str, String prefix) {
        return W.C.toString(str).startsWith(prefix);
    }

    public static String add(Object ... os) {
        return StringUtil.add("", os);
    }

    public static String add(String space, Object ... os) {
        StringBuilder sb = new StringBuilder();
        for (Object o : os) {
            sb.append(W.C.toString(o)).append(space);
        }
        return StringUtil.trim(sb.toString());
    }

    public static boolean equals(String str1, String str2) {
        return StringUtil.trim(str1).equals(StringUtil.trim(str2));
    }

    public static int getLength(String str) {
        if (U.E.isEmpty(str)) {
            return 0;
        }
        int length = 0;
        char[] temp = str.toCharArray();
        for (int i = 0; i < temp.length; ++i) {
            if (RegexUtil.isChinese(String.valueOf(temp[i]))) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static String sub(String str, String regex) {
        return StringUtil.sub(str, regex, 1);
    }

    public static String sub(String str, String regex, int index) {
        Matcher matcher = Pattern.compile(regex).matcher(str);
        return matcher.find(index - 1) ? matcher.group(index) : "";
    }

    public static String[] subAll(String str, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(str);
        String[] sub = new String[matcher.end()];
        for (int i = 0; i < sub.length; ++i) {
            sub[i] = matcher.group(i + 1);
        }
        return sub;
    }

    public static String subString(String str, String start, String end) {
        int j;
        if (U.E.isEmpty(str)) {
            return str;
        }
        int i = str.indexOf(start) == -1 ? 0 : str.indexOf(start) + start.length();
        int n = j = str.indexOf(end) == -1 ? str.length() : str.indexOf(end);
        if (j < i) {
            j = str.substring(i).indexOf(end);
            j = j == -1 ? str.length() : j + i;
        }
        return str.substring(i, j);
    }

    public static String subString(String str, int start) {
        return U.E.isEmpty(str) ? "" : StringUtil.subString(str, start, str.length());
    }

    public static String toParameters(Map<String, ?> map) {
        if (U.E.isEmpty(map)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<String> keys = Lists.sort(Lists.newList(map.keySet()));
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            String val = W.C.toString(map.get(key));
            if (!U.E.isNotEmpty(val)) continue;
            sb.append(key).append("=");
            sb.append(val).append("&");
        }
        return StringUtil.subString(sb.toString(), 0, sb.length() - 1);
    }

    public static String subString(String str, int start, int end) {
        if (U.E.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        start = start > len ? 0 : start;
        int n = end = end > len ? len : end;
        if (end < start && end < len) {
            str = str.substring(start);
            end = end == -1 ? len : end + start;
        }
        return str.substring(start, end);
    }

    public static String subStringLast(String str, String start, String end) {
        if (U.E.isEmpty(str)) {
            return str;
        }
        int i = str.lastIndexOf(start) == -1 ? 0 : str.lastIndexOf(start) + start.length();
        int j = str.lastIndexOf(end) == -1 ? 0 : str.lastIndexOf(end);
        return str.substring(i, j);
    }

    public static String subString(String str, String start) {
        int i;
        if (U.E.isEmpty(str)) {
            return str;
        }
        int n = i = str.indexOf(start) == -1 ? 0 : str.indexOf(start) + start.length();
        if (i == 0) {
            return str;
        }
        return str.substring(i, str.length());
    }

    public static String subStringLast(String str, String start) {
        int i;
        if (U.E.isEmpty(str)) {
            return str;
        }
        int n = i = str.lastIndexOf(start) == -1 ? 0 : str.lastIndexOf(start) + start.length();
        if (i == 0) {
            return str;
        }
        return str.substring(i, str.length());
    }

    public static String subStringEnd(String str, String end) {
        int i;
        if (U.E.isEmpty(str)) {
            return str;
        }
        int n = i = str.indexOf(end) == -1 ? 0 : str.indexOf(end);
        if (i == 0) {
            return str;
        }
        return str.substring(0, i);
    }

    public static String subStringLastEnd(String str, String end) {
        int i;
        if (U.E.isEmpty(str)) {
            return str;
        }
        int n = i = str.lastIndexOf(end) == -1 ? 0 : str.lastIndexOf(end);
        if (i == 0) {
            return str;
        }
        return str.substring(0, i);
    }

    public static String toCharset(String source, String tChar) {
        try {
            return U.E.isEmpty(source) ? source : new String(source.getBytes(), tChar);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String toCharset(String source, String sChar, String tChar) {
        try {
            return U.E.isEmpty(source) ? source : new String(source.getBytes(sChar), tChar);
        }
        catch (Exception e) {
            Logs.warn(e);
            return "";
        }
    }

    public static String convert(String name, String ... regex) {
        for (String n : regex) {
            name = StringUtil.convert(StringUtil.replaceAll(name, n));
        }
        return name;
    }

    public static String convert(String name) {
        if (U.E.isEmpty(name)) {
            return name;
        }
        String[] strs = name.split("_");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            String s = strs[i];
            if (!U.E.isNotEmpty(s)) continue;
            if (i == 0) {
                buf.append(s.substring(0, 1).toLowerCase());
            } else {
                buf.append(s.substring(0, 1).toUpperCase());
            }
            buf.append(s.substring(1, s.length()));
        }
        return buf.toString();
    }

    public static String toDbName(String name) {
        if (U.E.isEmpty(name)) {
            return name;
        }
        char[] cs = name.toCharArray();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            if (i == 0) {
                buf.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                buf.append("_").append(Character.toLowerCase(c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String toString(byte[] b) {
        return StringUtil.toString(b, CommonParams.ENCODING);
    }

    public static String toString(byte[] b, String charsetName) {
        try {
            return U.E.isEmpty(b) ? "" : new String(b, charsetName);
        }
        catch (Exception e) {
            Logs.warn(e);
            return "";
        }
    }

    public static byte[] toBytes(Object s) {
        return StringUtil.toBytes(W.C.toString(s));
    }

    public static byte[] toBytes(String s) {
        return StringUtil.toBytes(s, CommonParams.ENCODING);
    }

    public static byte[] toBytes(String s, String charsetName) {
        try {
            return U.E.isEmpty(s) ? ArrayConstants.BYTES_EMPTY : s.getBytes(charsetName);
        }
        catch (Exception e) {
            Logs.warn(e);
            return ArrayConstants.BYTES_EMPTY;
        }
    }

    public static boolean contains(String str, String searchStr) {
        if (U.E.isEmpty(str) || U.E.isEmpty(searchStr)) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }

    public static String trim(String s) {
        return W.C.toString(s).trim();
    }

    public static String replace(String s, String regex) {
        return U.E.isEmpty(s) ? "" : s.replace(regex, "");
    }

    public static String replace(String s, String regex, String replacement) {
        return U.E.isEmpty(s) ? "" : s.replace(regex, replacement);
    }

    public static String replaceAll(String s, String regex) {
        return U.E.isEmpty(s) ? "" : s.replaceAll(regex, "");
    }

    public static String replaceAll(String s, String regex, String replacement) {
        return U.E.isEmpty(s) ? "" : s.replaceAll(regex, replacement);
    }

    public static String[] split(String s, String regex) {
        return StringUtil.split(s, regex, ArrayConstants.STRING_EMPTY);
    }

    public static String[] split(String s, String regex, String[] def) {
        return U.E.isEmpty(s) ? def : s.split(regex);
    }

    public static String getMethodName(String prefix, String name) {
        return StringUtil.convert(prefix + "_" + name);
    }

    public static String resolve(String text, int len) {
        if (U.E.isEmpty(text)) {
            return text;
        }
        if (text.length() > len) {
            StringBuilder sb = new StringBuilder(len);
            int size = text.length() / len;
            for (int i = 0; i < len; ++i) {
                sb.append(text.charAt(i * size));
            }
            text = sb.toString();
        }
        return text;
    }

    public static String combine(String s1, String s2) {
        return U.E.isEmpty(s1) || U.E.isEmpty(s2) ? "" : StringUtil.combine(s1, s2, (s1.length() + s2.length()) / s1.length());
    }

    public static String combine(String s1, String s2, int len) {
        char[] c1 = s1.toCharArray();
        char[] c2 = s2.toCharArray();
        char[] c = new char[c1.length + c2.length];
        int i1 = 0;
        int i2 = 0;
        for (int i = 0; i < c.length; ++i) {
            c[i] = i % len == 0 ? c1[i1++] : c2[i2++];
        }
        return new String(c);
    }

    public static String[] separate(String s, int len) {
        try {
            if (U.E.isEmpty(s)) {
                return ArrayConstants.STRING_EMPTY;
            }
            char[] c = s.toCharArray();
            char[] c1 = new char[c.length / len];
            char[] c2 = new char[c.length - c1.length];
            int i1 = 0;
            int i2 = 0;
            for (int i = 0; i < c.length; ++i) {
                if (i % len == 0) {
                    c1[i1++] = c[i];
                    continue;
                }
                c2[i2++] = c[i];
            }
            return new String[]{new String(c1), new String(c2)};
        }
        catch (Exception e) {
            return ArrayConstants.STRING_EMPTY;
        }
    }
}

