/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.zip.base;

import com.weicoder.common.io.IOUtil;
import com.weicoder.common.log.Logs;
import com.weicoder.common.zip.Zip;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BaseZip
implements Zip {
    @Override
    public byte[] compress(byte[] b) {
        return this.compress(new ByteArrayInputStream(b)).toByteArray();
    }

    @Override
    public byte[] extract(byte[] b) {
        return this.extract(new ByteArrayInputStream(b)).toByteArray();
    }

    @Override
    public ByteArrayOutputStream compress(InputStream in) {
        return this.compress(in, new ByteArrayOutputStream());
    }

    @Override
    public ByteArrayOutputStream extract(InputStream in) {
        return this.extract(in, new ByteArrayOutputStream());
    }

    @Override
    public <E extends OutputStream> E compress(InputStream in, E out) {
        try {
            IOUtil.write(out, this.is(in));
        }
        catch (Exception e) {
            Logs.error(e);
        }
        return out;
    }

    @Override
    public <E extends OutputStream> E extract(InputStream in, E out) {
        try {
            IOUtil.write(this.os(out), in);
        }
        catch (Exception e) {
            Logs.error(e);
        }
        return out;
    }

    protected abstract InputStream is(InputStream var1) throws Exception;

    protected abstract OutputStream os(OutputStream var1) throws Exception;
}

