/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.binary;

import com.weicoder.common.binary.ByteArray;
import com.weicoder.common.constants.C;
import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.lang.W;
import com.weicoder.common.params.P;
import com.weicoder.common.util.U;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class Buffer
implements ByteArray {
    private static final Buffer EMPTY = new Buffer(C.A.BYTES_EMPTY);
    private byte[] data;
    private int top;
    private int offset;
    private boolean sync;
    private Lock lock;

    public Buffer() {
        this(false);
    }

    public Buffer(boolean sync) {
        this(P.C.IO_BUFFERSIZE, sync);
    }

    public Buffer(int capacity, boolean sync) {
        this(new byte[capacity], 0, 0, sync);
    }

    public Buffer(byte[] data) {
        this(data, false);
    }

    public Buffer(byte[] data, boolean sync) {
        this(data, 0, data.length, sync);
    }

    public Buffer(byte[] data, int index, int length, boolean sync) {
        this.data = data;
        this.top = index + length;
        this.offset = index;
        this.sync = sync;
        if (sync) {
            this.lock = new ReentrantLock(true);
        }
    }

    public static Buffer allocate(int capacity) {
        return new Buffer(capacity, false);
    }

    public static Buffer wrap(byte[] array) {
        return new Buffer(array);
    }

    public static Buffer wrap(byte[] array, int offset, int length) {
        return new Buffer(array, offset, length, false);
    }

    public static Buffer empty() {
        return EMPTY;
    }

    public void capacity(int len) {
        if (len <= this.length()) {
            return;
        }
        if (this.sync) {
            this.lock.lock();
        }
        this.data = W.B.copy(this.data, this.length() + len * 10);
        if (this.sync) {
            this.lock.unlock();
        }
    }

    public int top() {
        return this.top;
    }

    public void top(int top) {
        if (top < this.offset) {
            return;
        }
        if (top > this.length()) {
            this.capacity(top);
        }
        this.top = top;
    }

    public int offset() {
        return this.offset;
    }

    public void offset(int offset) {
        if (offset < 0 || offset > this.top) {
            return;
        }
        this.offset = offset;
    }

    public void reset() {
        this.offset = 0;
        this.top = this.length();
    }

    public void reset(int n) {
        this.offset(this.offset - n);
    }

    public int remain() {
        return this.top - this.offset;
    }

    public boolean has() {
        return this.remain() > 0;
    }

    public void forEach(Calls.EoV<Buffer> call) {
        this.for1(() -> this, call);
    }

    public void longs(Calls.EoV<Long> call) {
        this.for1(() -> this.readLong(), call);
    }

    public List<Long> longs() {
        List<Long> ls = W.L.list(this.remain() / 8);
        this.longs(l -> ls.add((Long)l));
        return ls;
    }

    public void ints(Calls.EoV<Integer> call) {
        this.for1(() -> this.readInt(), call);
    }

    public List<Integer> ints() {
        List<Integer> ls = W.L.list(this.remain() / 4);
        this.ints(l -> ls.add((Integer)l));
        return ls;
    }

    public void shorts(Calls.EoV<Short> call) {
        this.for1(() -> this.readShort(), call);
    }

    public List<Short> shorts() {
        List<Short> ls = W.L.list(this.remain() / 2);
        this.shorts(l -> ls.add((Short)l));
        return ls;
    }

    public void floats(Calls.EoV<Float> call) {
        this.for1(() -> Float.valueOf(this.readFloat()), call);
    }

    public List<Float> floats() {
        List<Float> ls = W.L.list(this.remain() / 4);
        this.floats(l -> ls.add((Float)l));
        return ls;
    }

    public void doubles(Calls.EoV<Double> call) {
        this.for1(() -> this.readDouble(), call);
    }

    public List<Double> doubles() {
        List<Double> ls = W.L.list(this.remain() / 8);
        this.doubles(l -> ls.add((Double)l));
        return ls;
    }

    public void bytes(int len, Calls.EoV<byte[]> call) {
        this.for1(() -> this.read(len), call);
    }

    public List<byte[]> bytes(int len) {
        List<byte[]> ls = W.L.list(this.remain() / len);
        this.bytes(len, l -> ls.add((byte[])l));
        return ls;
    }

    public void bytes(Calls.EoV<Byte> call) {
        this.for1(() -> this.readByte(), call);
    }

    public int length() {
        return this.data.length;
    }

    public byte[] read(int len) {
        return this.read(new byte[len]);
    }

    public byte[] read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(byte[] data, int pos, int len) {
        if (this.sync) {
            this.lock.lock();
        }
        try {
            System.arraycopy(this.data, this.offset, data, pos, len);
            this.offset += len;
        }
        catch (Exception exception) {
        }
        finally {
            if (this.sync) {
                this.lock.unlock();
            }
        }
        return data;
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte() {
        return this.read(1)[0];
    }

    public char readChar() {
        return (char)this.readShort();
    }

    public short readShort() {
        return W.B.toShort(this.read(2));
    }

    public int readInt() {
        return W.B.toInt(this.read(4));
    }

    public float readFloat() {
        return W.B.toFloat(this.read(4));
    }

    public long readLong() {
        return W.B.toLong(this.read(8));
    }

    public double readDouble() {
        return W.B.toDouble(this.read(8));
    }

    public String readString(int len) {
        return len == 0 ? "" : new String(this.read(new byte[len], 0, len));
    }

    public String readString() {
        return this.readString(this.readShort());
    }

    public byte[] write(byte[] data) {
        return this.write(data, 0, data.length);
    }

    public byte[] write(byte[] data, int pos, int len) {
        this.capacity(this.top + len);
        if (this.sync) {
            this.lock.lock();
        }
        System.arraycopy(data, pos, this.data, this.top, len);
        this.top += len;
        if (this.sync) {
            this.lock.unlock();
        }
        return data;
    }

    public void writeBoolean(boolean b) {
        this.writeByte((byte)(b ? 1 : 0));
    }

    public void writeByte(byte b) {
        this.write(new byte[]{b});
    }

    public void writeChar(char c) {
        this.write(W.B.toBytes(c), 0, 2);
    }

    public void writeShort(int i) {
        this.writeShort((short)i);
    }

    public void writeShort(short s) {
        this.writeShort(s, 0);
    }

    public void writeShort(short s, int pos) {
        this.write(W.B.toBytes(s), pos, pos + 2);
    }

    public void writeInt(int i) {
        this.writeInt(i, 0);
    }

    public void writeInt(int i, int pos) {
        this.write(W.B.toBytes(i), pos, pos + 4);
    }

    public void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeLong(long l) {
        this.writeLong(l, 0);
    }

    public void writeLong(long l, int pos) {
        this.write(W.B.toBytes(l), pos, pos + 8);
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeString(String s) {
        if (U.E.isEmpty(s)) {
            this.writeShort(0);
        } else {
            byte[] temp = U.S.toBytes(s);
            this.writeShort(temp.length);
            this.write(temp, 0, temp.length);
        }
    }

    public void handle() {
        if (this.has()) {
            this.compact();
        } else {
            this.clear();
        }
    }

    public void compact() {
        if (this.offset > 0) {
            if (this.sync) {
                this.lock.lock();
            }
            System.arraycopy(this.data, this.offset, this.data, 0, this.remain());
            this.top -= this.offset;
            this.offset = 0;
            if (this.sync) {
                this.lock.unlock();
            }
        }
    }

    public void clear() {
        if (this.length() < P.C.BUFFER_SIZE) {
            this.data = new byte[P.C.BUFFER_SIZE];
        }
        this.top = 0;
        this.offset = 0;
    }

    @Override
    public byte[] array() {
        return W.B.copy(this.data, 0, this.top);
    }

    @Override
    public ByteArray array(byte[] b) {
        this.clear();
        this.write(b);
        return this;
    }

    public String toString() {
        return U.S.add("", "(top=", this.top, ",offset=", this.offset, ",len=" + this.length() + ")");
    }

    private <E> void for1(Calls.ZoR<E> e, Calls.EoV<E> call) {
        while (this.has()) {
            call.call(e.call());
        }
    }
}

