/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.crypto;

import com.weicoder.common.codec.Hex;
import com.weicoder.common.constants.C;
import com.weicoder.common.crypto.Digest;
import com.weicoder.common.crypto.base.BaseCrypt;
import com.weicoder.common.params.P;
import com.weicoder.common.util.U;

public class Decrypts
extends BaseCrypt {
    public static byte[] token(String info) {
        String user;
        String ver;
        String t;
        String[] temp;
        String token = U.S.replace(U.S.trim(info), "\"", "");
        if (U.E.isNotEmpty(token) && token.length() > P.C.TOKEN_LENGHT && U.E.isNotEmpty(temp = U.S.separate(t = token.toLowerCase(), t.length() / P.C.TOKEN_LENGHT)) && temp.length == 2 && (ver = temp[0]).equals(Digest.absolute(user = temp[1], P.C.TOKEN_LENGHT))) {
            return Decrypts.rc4(Hex.decode(user));
        }
        return C.A.BYTES_EMPTY;
    }

    public static String decryptString(String text) {
        return U.S.toString(Decrypts.decrypt(text));
    }

    public static byte[] decrypt(String text) {
        return Decrypts.decrypt(Hex.decode(text));
    }

    public static byte[] decrypt(byte[] b) {
        return Decrypts.decrypt(b, P.C.ENCRYPT_KEY);
    }

    public static byte[] decrypt(byte[] b, String keys) {
        switch (P.C.ENCRYPT_ALGO) {
            case "AES": {
                return Decrypts.aes(b, keys);
            }
            case "DES": {
                return Decrypts.des(b, keys);
            }
            case "RC4": {
                return Decrypts.rc4(b, keys);
            }
        }
        return Decrypts.aes(b, keys);
    }

    public static byte[] des(byte[] b) {
        return Decrypts.des(b, P.C.ENCRYPT_KEY);
    }

    public static byte[] des(byte[] b, String keys) {
        return Decrypts.decrypt(b, keys, 8, "DES");
    }

    public static byte[] aes(byte[] b) {
        return Decrypts.aes(b, P.C.ENCRYPT_KEY);
    }

    public static byte[] aes(byte[] b, String keys) {
        return Decrypts.decrypt(b, keys, 16, "AES");
    }

    public static byte[] rc4(byte[] b) {
        return Decrypts.rc4(b, P.C.ENCRYPT_KEY);
    }

    public static byte[] rc4(byte[] b, String keys) {
        return Decrypts.decrypt(b, keys, 16, "RC4");
    }

    private static byte[] decrypt(byte[] b, String keys, int len, String algorithm) {
        return Decrypts.doFinal(b, keys, len, algorithm, 2);
    }
}

