/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.crypto;

import com.weicoder.common.codec.Hex;
import com.weicoder.common.crypto.Digest;
import com.weicoder.common.crypto.base.BaseCrypt;
import com.weicoder.common.lang.W;
import com.weicoder.common.params.P;
import com.weicoder.common.util.U;

public class Encrypts
extends BaseCrypt {
    public static String token(byte[] array) {
        String info = Hex.encode(Encrypts.rc4(array, P.C.TOKEN_KEY));
        return U.S.combine(Digest.absolute(info, P.C.TOKEN_LENGHT), info).toUpperCase();
    }

    public static String encrypt(Object obj) {
        return obj instanceof String ? Encrypts.encrypt(W.C.toString(obj)) : Hex.encode(Encrypts.encrypt(W.B.toBytes(obj)));
    }

    public static String encrypt(String text) {
        return Hex.encode(Encrypts.encrypt(U.S.toBytes(text)));
    }

    public static byte[] encrypt(byte[] b) {
        return Encrypts.encrypt(b, P.C.ENCRYPT_KEY);
    }

    public static byte[] encrypt(byte[] b, String key) {
        switch (P.C.ENCRYPT_ALGO) {
            case "AES": {
                return Encrypts.aes(b, key);
            }
            case "DES": {
                return Encrypts.des(b, key);
            }
            case "RC4": {
                return Encrypts.rc4(b, key);
            }
        }
        return Encrypts.aes(b, key);
    }

    public static byte[] des(byte[] b) {
        return Encrypts.des(b, P.C.ENCRYPT_KEY);
    }

    public static byte[] des(byte[] b, String key) {
        return Encrypts.encrypt(b, key, 8, "DES");
    }

    public static byte[] aes(byte[] b) {
        return Encrypts.aes(b, P.C.ENCRYPT_KEY);
    }

    public static byte[] aes(byte[] b, String key) {
        return Encrypts.encrypt(b, key, 16, "AES");
    }

    public static byte[] rc4(byte[] b) {
        return Encrypts.rc4(b, P.C.ENCRYPT_KEY);
    }

    public static byte[] rc4(byte[] b, String key) {
        return Encrypts.encrypt(b, key, 16, "RC4");
    }

    private static byte[] encrypt(byte[] b, String keys, int len, String algorithm) {
        return Encrypts.doFinal(b, keys, len, algorithm, 1);
    }
}

