/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.crypto;

import com.weicoder.common.codec.Hex;
import com.weicoder.common.constants.C;
import com.weicoder.common.params.P;
import com.weicoder.common.util.U;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HMac {
    public static String sha1(String text) {
        return Hex.encode(HMac.sha1(U.S.toBytes(text)));
    }

    public static byte[] sha1(byte[] b) {
        return HMac.sha1(b, P.C.ENCRYPT_KEY);
    }

    public static byte[] sha1(byte[] b, String key) {
        return HMac.doFinal(b, "HmacSHA1", key);
    }

    public static String sha256(String text) {
        return Hex.encode(HMac.sha256(U.S.toBytes(text)));
    }

    public static byte[] sha256(byte[] b) {
        return HMac.doFinal(b, "HmacSHA256", P.C.ENCRYPT_KEY);
    }

    public static String sha384(String text) {
        return Hex.encode(HMac.sha384(U.S.toBytes(text)));
    }

    public static byte[] sha384(byte[] b) {
        return HMac.doFinal(b, "HmacSHA384", P.C.ENCRYPT_KEY);
    }

    public static String sha512(String text) {
        return Hex.encode(HMac.sha512(U.S.toBytes(text)));
    }

    public static byte[] sha512(byte[] b) {
        return HMac.doFinal(b, "HmacSHA512", P.C.ENCRYPT_KEY);
    }

    private static byte[] doFinal(byte[] b, String algorithm, String keys) {
        try {
            if (U.E.isEmptys(b, algorithm, keys)) {
                return C.A.BYTES_EMPTY;
            }
            return HMac.getMac(algorithm, keys).doFinal(b);
        }
        catch (Exception e) {
            return C.A.BYTES_EMPTY;
        }
    }

    private static Mac getMac(String algorithm, String keys) {
        Mac mac = null;
        try {
            mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(U.S.toBytes(keys), algorithm));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mac;
    }

    private HMac() {
    }
}

