/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.crypto.base;

import com.weicoder.common.constants.C;
import com.weicoder.common.util.U;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseCrypt {
    protected static final byte[] doFinal(byte[] b, String keys, int len, String algorithm, int mode) {
        return BaseCrypt.doFinal(b, BaseCrypt.getKey(algorithm, keys, len), algorithm, mode);
    }

    protected static final byte[] doFinal(byte[] b, Key key, String algorithm, int mode) {
        try {
            if (U.E.isEmpty(b)) {
                return b;
            }
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(mode, key);
            return cipher.doFinal(b);
        }
        catch (Exception e) {
            return C.A.BYTES_EMPTY;
        }
    }

    private static Key getKey(String algorithm, String keys, int len) {
        return new SecretKeySpec(U.S.toBytes(U.S.resolve(keys, len)), 0, len, algorithm);
    }
}

