/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.http.impl;

import com.weicoder.common.constants.C;
import com.weicoder.common.http.Http;
import com.weicoder.common.lang.W;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.U;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

public class Jdk11Http
implements Http {
    private final HttpClient CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();

    @Override
    public String post(String url, Map<String, Object> data, Map<String, Object> header) {
        try {
            String body = U.S.add("?", U.S.toParameters(data));
            HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url + body));
            if (U.E.isNotEmpty(header)) {
                header.forEach((k, v) -> builder.setHeader((String)k, W.C.toString(v)));
            }
            HttpRequest request = builder.POST(HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<String> response = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body();
        }
        catch (Exception e) {
            Logs.error(e, "Jdk11Http post url={} data={} header={}", url, data, header);
            return "";
        }
    }

    @Override
    public byte[] download(String url, Map<String, Object> header) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url));
            if (U.E.isNotEmpty(header)) {
                for (Map.Entry<String, Object> h : header.entrySet()) {
                    builder.setHeader(h.getKey(), W.C.toString(h.getValue()));
                }
            }
            HttpRequest request = builder.GET().build();
            HttpResponse<byte[]> response = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofByteArray());
            return response.body();
        }
        catch (Exception e) {
            Logs.error(e, "Jdk11Http download url={}", url);
            return C.A.BYTES_EMPTY;
        }
    }
}

