/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.http.impl;

import com.weicoder.common.constants.C;
import com.weicoder.common.http.Http;
import com.weicoder.common.io.I;
import com.weicoder.common.lang.W;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.P;
import com.weicoder.common.statics.S;
import com.weicoder.common.util.U;
import com.weicoder.common.zip.Zip;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Map;

public class Jdk8Http
implements Http {
    private Zip gzip = S.Z.get("gzip");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] download(String url, Map<String, Object> header) {
        HttpURLConnection conn = null;
        try {
            conn = Jdk8Http.getConnection(url);
            if (U.E.isNotEmpty(header)) {
                for (Map.Entry<String, Object> h : header.entrySet()) {
                    conn.setRequestProperty(h.getKey(), W.C.toString(h.getValue()));
                }
            }
            conn.setRequestMethod("GET");
            conn.connect();
            Object object = this.gzip.extract(I.read(conn.getInputStream()));
            return object;
        }
        catch (IOException e) {
            Logs.error(e, "HttpEngine get url={}", url);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return C.A.BYTES_EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String post(String url, Map<String, Object> data, Map<String, Object> header) {
        HttpURLConnection conn = null;
        try {
            conn = Jdk8Http.getConnection(url);
            if (U.E.isNotEmpty(header)) {
                for (Map.Entry<String, Object> h : header.entrySet()) {
                    conn.setRequestProperty(h.getKey(), W.C.toString(h.getValue()));
                }
            }
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
            if (U.E.isNotEmpty(data)) {
                StringBuilder sb = new StringBuilder();
                data.entrySet().forEach(e -> sb.append((String)e.getKey()).append("=").append(e.getValue()).append("&"));
                I.write(conn.getOutputStream(), sb.substring(0, sb.length() - 1));
            }
            String res = U.S.toString(this.gzip.extract(I.read(conn.getInputStream())));
            Logs.debug("HttpEngine post url={} data={} header={} res={}", url, data, header, res);
            String string = res;
            return string;
        }
        catch (IOException e2) {
            Logs.error(e2, "HttpEngine post url={} data={} header={}", url, data, header);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return "";
    }

    private static HttpURLConnection getConnection(String url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)URI.create(url).toURL().openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; nl; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13");
            conn.setRequestProperty("Accept", "text/xml,text/javascript,application/json,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
            conn.setRequestProperty("Accept-Language", "zh-cn,zh;q=0.5");
            conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            conn.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setConnectTimeout(P.H.CONNECT_TIMEOUT);
            conn.setReadTimeout(P.H.READ_TIMEOUT);
        }
        catch (Exception e) {
            Logs.error(e, "HttpEngine getConnection url={}", url);
        }
        return conn;
    }
}

