/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.constants.C;
import com.weicoder.common.io.I;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.P;
import com.weicoder.common.statics.S;
import com.weicoder.common.util.U;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;

public sealed class AsynChannelUtil
permits I.A {
    public static byte[] read(AsynchronousByteChannel asc) {
        return AsynChannelUtil.read(asc, P.C.IO_CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] read(AsynchronousByteChannel asc, boolean isClose) {
        byte[] byArray;
        ByteArrayOutputStream out;
        block13: {
            if (asc == null) {
                return C.A.BYTES_EMPTY;
            }
            out = new ByteArrayOutputStream();
            ByteBuffer buffer = ByteBuffer.allocate(P.C.IO_BUFFERSIZE);
            int num = 0;
            while ((num = asc.read(buffer).get().intValue()) > 0) {
                out.write(buffer.hasArray() ? buffer.array() : C.A.BYTES_EMPTY, 0, num);
                buffer.clear();
            }
            byArray = out.toByteArray();
            out.close();
            if (!isClose) break block13;
            S.C.close(asc);
        }
        return byArray;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Logs.error(e);
                        byte[] byArray2 = C.A.BYTES_EMPTY;
                        if (isClose) {
                            S.C.close(asc);
                        }
                        return byArray2;
                    }
                }
                catch (Throwable throwable3) {
                    if (isClose) {
                        S.C.close(asc);
                    }
                    throw throwable3;
                }
            }
        }
    }

    public static int write(AsynchronousByteChannel asc, byte[] b) {
        return AsynChannelUtil.write(asc, b, P.C.IO_CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int write(AsynchronousByteChannel asc, byte[] b, boolean isClose) {
        int n;
        block6: {
            if (asc == null || U.E.isEmpty(b)) {
                return -1;
            }
            try {
                n = asc.write(ByteBuffer.wrap(b)).get();
                if (!isClose) break block6;
            }
            catch (Exception e) {
                int n2;
                block7: {
                    try {
                        Logs.error(e);
                        n2 = -1;
                        if (!isClose) break block7;
                    }
                    catch (Throwable throwable) {
                        if (isClose) {
                            S.C.close(asc);
                        }
                        throw throwable;
                    }
                    S.C.close(asc);
                }
                return n2;
            }
            S.C.close(asc);
        }
        return n;
    }
}

