/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.binary.Buffer;
import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.io.I;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.P;
import com.weicoder.common.statics.S;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public sealed class ChannelUtil
permits I.C {
    public static byte[] read(ReadableByteChannel ch) {
        return ChannelUtil.read(ch, P.C.IO_CLOSE);
    }

    public static byte[] read(ReadableByteChannel ch, boolean isClose) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(P.C.IO_BUFFERSIZE);
        ChannelUtil.write(ch, Channels.newChannel(out), isClose);
        return out.toByteArray();
    }

    public static long write(WritableByteChannel wbc, byte[] b) {
        return ChannelUtil.write(wbc, b, P.C.IO_CLOSE);
    }

    public static long write(WritableByteChannel wbc, byte[] b, boolean isClose) {
        return ChannelUtil.write(wbc, new ByteArrayInputStream(b), isClose);
    }

    public static long write(WritableByteChannel wbc, InputStream in) {
        return ChannelUtil.write(wbc, in, P.C.IO_CLOSE);
    }

    public static long write(WritableByteChannel wbc, InputStream in, boolean isClose) {
        return ChannelUtil.write(Channels.newChannel(in), wbc, isClose);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int write(String file, ByteBuffer src) {
        try (FileOutputStream fos = I.F.getOutputStream(file, true);){
            int n;
            block14: {
                WritableByteChannel wbc = Channels.newChannel(fos);
                try {
                    n = wbc.write(src);
                    if (wbc == null) break block14;
                }
                catch (Throwable throwable) {
                    if (wbc != null) {
                        try {
                            wbc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                wbc.close();
            }
            return n;
        }
        catch (Exception e) {
            Logs.error(e);
            return -1;
        }
    }

    public static long write(ReadableByteChannel rbc, WritableByteChannel wbc, boolean isClose) {
        return ChannelUtil.write(rbc, wbc, P.C.IO_BUFFERSIZE, isClose, r -> r);
    }

    public static long write(ReadableByteChannel rbc, WritableByteChannel wbc, int buff, Calls.EoR<Buffer, Buffer> call) {
        return ChannelUtil.write(rbc, wbc, buff, false, call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long write(ReadableByteChannel rbc, WritableByteChannel wbc, int buff, boolean isClose, Calls.EoR<Buffer, Buffer> call) {
        if (wbc == null || rbc == null) {
            return -1L;
        }
        long sum = 0L;
        try {
            ByteBuffer buffer = ByteBuffer.allocate(buff);
            int num = 0;
            while ((num = rbc.read(buffer)) > 0) {
                Buffer buf = call.call(Buffer.wrap(buffer.array(), 0, num));
                if (buf.length() > 0) {
                    wbc.write(ByteBuffer.wrap(buf.array()));
                }
                buffer.clear();
                sum += (long)num;
            }
            if (!isClose) return sum;
        }
        catch (IOException e) {
            try {
                Logs.error(e);
                if (!isClose) return sum;
            }
            catch (Throwable throwable) {
                if (!isClose) throw throwable;
                S.C.close(wbc, rbc);
                throw throwable;
            }
            S.C.close(wbc, rbc);
            return sum;
        }
        S.C.close(wbc, rbc);
        return sum;
    }
}

