/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.binary.Buffer;
import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.params.P;
import com.weicoder.common.util.U;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

interface IO {
    default public String readString(InputStream in) {
        return this.readString(in, P.C.ENCODING);
    }

    default public String readString(InputStream in, String charsetName) {
        return this.readString(in, charsetName, P.C.IO_CLOSE);
    }

    default public byte[] read(InputStream in) {
        return this.read(in, P.C.IO_CLOSE);
    }

    public byte[] read(InputStream var1, boolean var2);

    public long read(InputStream var1, int var2, boolean var3, Calls.EoV<Buffer> var4);

    default public long write(OutputStream out, String text) {
        return this.write(out, U.S.toBytes(text));
    }

    default public long write(OutputStream out, String text, String charsetName) {
        return this.write(out, text, charsetName, P.C.IO_CLOSE);
    }

    default public long write(OutputStream out, byte[] b) {
        return this.write(out, b, P.C.IO_CLOSE);
    }

    default public long write(OutputStream out, byte[] b, boolean isClose) {
        return this.write(out, new ByteArrayInputStream(b), isClose);
    }

    default public long write(OutputStream out, InputStream in) {
        return this.write(out, in, P.C.IO_CLOSE);
    }

    public long write(OutputStream var1, InputStream var2, boolean var3);

    public long write(OutputStream var1, InputStream var2, int var3, boolean var4, Calls.EoR<Buffer, Buffer> var5);

    default public String readString(InputStream in, String charsetName, boolean isClose) {
        return U.S.toString(this.read(in, isClose), charsetName);
    }

    default public long write(OutputStream out, String text, String charsetName, boolean isClose) {
        return this.write(out, U.S.toBytes(text, charsetName), isClose);
    }
}

