/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.binary.Buffer;
import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.io.BIO;
import com.weicoder.common.io.I;
import com.weicoder.common.io.IO;
import com.weicoder.common.io.NIO;
import com.weicoder.common.params.P;
import java.io.InputStream;
import java.io.OutputStream;

public sealed class IOUtil
permits I {
    public static final IO BIO = new BIO();
    public static final IO NIO = new NIO();
    private static final IO IO = "bio".equalsIgnoreCase(P.C.IO_MODE) ? BIO : NIO;

    public static long write(OutputStream out, InputStream in, Calls.EoR<Buffer, Buffer> call) {
        return IOUtil.write(out, in, P.C.IO_BUFFERSIZE, P.C.IO_CLOSE, call);
    }

    public static long write(OutputStream out, InputStream in, int buff, boolean isClose, Calls.EoR<Buffer, Buffer> call) {
        return IO.write(out, in, buff, isClose, call);
    }

    public static String readString(InputStream in) {
        return IO.readString(in);
    }

    public static String readString(InputStream in, String charsetName) {
        return IO.readString(in, charsetName);
    }

    public static String readString(InputStream in, String charsetName, boolean isClose) {
        return IO.readString(in, charsetName, isClose);
    }

    public static byte[] read(InputStream in) {
        return IO.read(in);
    }

    public static long read(InputStream in, int buff, boolean isClose, Calls.EoV<Buffer> call) {
        return IO.read(in, buff, isClose, call);
    }

    public static byte[] read(InputStream in, boolean isClose) {
        return IO.read(in, isClose);
    }

    public static long write(OutputStream out, String text) {
        return IO.write(out, text);
    }

    public static long write(OutputStream out, String text, String charsetName) {
        return IO.write(out, text, charsetName);
    }

    public static long write(OutputStream out, String text, String charsetName, boolean isClose) {
        return IO.write(out, text, charsetName, isClose);
    }

    public static long write(OutputStream out, byte[] b) {
        return IO.write(out, b);
    }

    public static long write(OutputStream out, byte[] b, boolean isClose) {
        return IO.write(out, b, isClose);
    }

    public static long write(OutputStream out, InputStream in) {
        return IO.write(out, in);
    }

    public static long write(OutputStream out, InputStream in, boolean isClose) {
        return IO.write(out, in, isClose);
    }
}

