/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.lang;

import com.weicoder.common.lang.W;
import com.weicoder.common.util.ArrayUtil;
import com.weicoder.common.util.U;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public sealed class Lists
permits W.L {
    public static <E> List<E> toList(Collection<?> list, Class<E> cls) {
        return Lists.list(list).stream().map(l -> U.C.isBaseType(cls) ? W.C.to(l, cls) : U.B.copy(l, cls)).collect(Collectors.toList());
    }

    public static <E> List<E> notNull(List<E> list) {
        return U.E.isEmpty(list) || list.indexOf(null) == 0 ? list : list.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <E> E get(List<E> list, int i) {
        return U.E.isEmpty(list) ? null : (i < 0 ? (E)list.get(0) : (i >= list.size() ? (E)list.get(list.size() - 1) : (E)list.get(i)));
    }

    public static <E> E last(List<E> list) {
        return U.E.isEmpty(list) ? null : (E)list.get(list.size() - 1);
    }

    public static boolean is(Object obj) {
        return U.E.isNotEmpty(obj) && obj instanceof List;
    }

    public static <E> List<E> list() {
        return new ArrayList();
    }

    public static <E> List<E> sync() {
        return Lists.sync(Lists.list());
    }

    public static <E> List<E> sync(List<E> list) {
        return Collections.synchronizedList(list);
    }

    public static <E> List<E> list(int size) {
        return new ArrayList(size < 1 ? 1 : size);
    }

    @SafeVarargs
    public static <E> List<E> list(E ... es) {
        return Lists.list(U.A.toList(es));
    }

    public static <E> List<E> list(Collection<E> c) {
        return c == null ? new ArrayList() : new ArrayList<E>(c);
    }

    public static <E> List<E> copy(Collection<E> c) {
        List<E> l = Lists.list(c);
        c.clear();
        return l;
    }

    @SafeVarargs
    public static <E> List<E> list(Collection<E> ... c) {
        List<E> list = Lists.list();
        for (int i = 0; i < c.length; ++i) {
            if (!U.E.isNotEmpty(c[i])) continue;
            list.addAll(c[i]);
        }
        return list;
    }

    public static <E> List<List<E>> slice(List<E> list, int slice) {
        List<List<List<E>>> res = Lists.list();
        if (U.E.isEmpty(list) || slice < 1 || list.size() <= slice) {
            res.add(list);
        } else {
            List<E> ls;
            int n = 0;
            do {
                int start = n * slice;
                ls = Lists.sub(list, start, start + slice);
                ++n;
                if (!U.E.isNotEmpty(ls)) continue;
                res.add(ls);
            } while (ls.size() >= slice);
        }
        return res;
    }

    public static <E> List<E> sub(List<E> list, int begin, int end) {
        if (U.E.isEmpty(list)) {
            return list;
        }
        int size = list.size();
        if (begin < 1 && end >= size) {
            return list;
        }
        if (begin > size) {
            return Lists.empty();
        }
        begin = begin < 0 ? 0 : begin;
        end = begin > end ? begin + end : end;
        end = end < 1 || end > size ? size : end;
        return list.subList(begin, end);
    }

    public static <E extends Comparable<? super E>> List<E> sort(List<E> list) {
        list.sort(null);
        return list;
    }

    public static String toString(List<?> list) {
        return ArrayUtil.toString(Lists.toArray(list));
    }

    public static <E> E[] toArray(List<E> list) {
        if (U.E.isEmpty(list)) {
            return ArrayUtil.getArray(new Object[0]);
        }
        return list.toArray(ArrayUtil.getArray(list.get(0).getClass(), list.size()));
    }

    public static <E> E[] toArray(List<Object> list, Class<E> clazz) {
        if (U.E.isEmpty(list)) {
            return ArrayUtil.getArray(clazz, 0);
        }
        return list.toArray(ArrayUtil.getArray(clazz, list.size()));
    }

    public static <E> List<E> empty() {
        return Collections.emptyList();
    }

    public static boolean contains(List<Object> list, Object o) {
        if (U.E.isNotEmpty(list) && o != null) {
            for (Object obj : list) {
                if (!(o.getClass().equals(obj.getClass()) ? o.equals(obj) : W.C.toString(o).equals(W.C.toString(obj)))) continue;
                return true;
            }
        }
        return false;
    }

    public static int size(List<?> list) {
        return U.E.isEmpty(list) ? 0 : list.size();
    }
}

