/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.lang;

import com.weicoder.common.lang.W;
import com.weicoder.common.util.U;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public sealed class Maps
permits W.M {
    public static <K, V> V get(Map<K, V> map, K key, Class<V> c) {
        if (map == null || key == null || c == null) {
            return null;
        }
        V val = map.get(key);
        if (val == null) {
            val = U.C.newInstance(c, new Class[0]);
            map.put(key, val);
        }
        return val;
    }

    public static <K, V> List<V> getList(Map<K, List<V>> map, K key) {
        if (map == null || key == null) {
            return W.L.empty();
        }
        List<Object> val = map.get(key);
        if (val == null) {
            val = W.L.list();
            map.put(key, val);
        }
        return val;
    }

    public static <K, O, V> Map<O, V> getMap(Map<K, Map<O, V>> map, K key) {
        if (map == null || key == null) {
            return Maps.empty();
        }
        Map<Object, V> val = map.get(key);
        if (val == null) {
            val = Maps.map();
            map.put(key, val);
        }
        return val;
    }

    public static boolean isMap(Object obj) {
        return U.E.isNotEmpty(obj) && obj instanceof Map;
    }

    public static <K, V> Map<K, V> map(K key, V value) {
        Map<K, V> map = Maps.map();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> map(K[] keys, V[] values) {
        return Maps.map(W.L.list(keys), W.L.list(values));
    }

    public static <K, V> Map<K, V> map(List<K> keys, List<V> values) {
        if (U.E.isEmpty(keys) || U.E.isEmpty(values) || keys.size() != values.size()) {
            return Maps.empty();
        }
        Map<K, V> map = Maps.map();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    public static <K, V> Map<K, V> map() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> map(int size) {
        return new HashMap(size < 1 ? 1 : size);
    }

    public static <K, V> Map<K, V> map(Map<K, V> map) {
        return map == null ? new HashMap() : new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> copy(Map<K, V> map) {
        Map<K, V> m = Maps.map(map);
        map.clear();
        return m;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> map(Map<K, V> ... maps) {
        Map<K, V> map = Maps.map();
        for (int i = 0; i < maps.length; ++i) {
            map.putAll(maps[i]);
        }
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrent() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> concurrent(int size) {
        return new ConcurrentHashMap(size);
    }

    public static <K, V> ConcurrentMap<K, V> concurrent(Map<K, V> map) {
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static int size(Map<?, ?> map) {
        return U.E.isEmpty(map) ? 0 : map.size();
    }
}

