/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.params;

import com.weicoder.common.constants.C;
import com.weicoder.common.lang.W;
import com.weicoder.common.params.P;
import com.weicoder.common.util.U;
import java.util.Set;

public sealed class CommonParams
permits P.C {
    public static final String LOG_CLASS = P.getString("log.class", "com.weicoder.log4j.Log4j2");
    public static final int BUFFER_SIZE = P.getInt("buffer.size", 0x100000);
    public static final int IO_BUFFERSIZE = P.getInt("io.buffer", BUFFER_SIZE);
    public static final String IO_MODE = P.getString("io.mode", "nio");
    public static final boolean IO_CLOSE = P.getBoolean("io.close", true);
    public static final boolean FILE_APPEND = P.getBoolean("file.append", true);
    public static final String ENCODING = P.getString("encoding", "UTF-8");
    public static final String DATE_FORMAT = P.getString("date.format", "yyyy-MM-dd HH:mm:ss");
    public static final String BYTES = P.getString("bytes", "high");
    public static final String ENCRYPT_KEY = P.getString("encrypt.key", "www.weicoder.com");
    public static final String ENCRYPT_ALGO = P.getString("encrypt.algo", "AES");
    public static final String ENCRYPT_DIGEST = P.getString("encrypt.digest", "SHA-1");
    public static final String[] IPS = P.getStringArray("ips", C.A.STRING_EMPTY);
    public static final String TOKEN_KEY = P.getString("token.key");
    public static final int TOKEN_LENGHT = P.getInt("token.lenght", 8);
    public static final short TOKEN_SIGN = P.getShort("token.sign", (short)-128);
    public static final int TOKEN_EXPIRE = P.getInt("token.expire", 691200);
    public static final Set<String> TOKEN_SERVERS = W.S.set(P.getStringArray("token.servers", C.A.STRING_EMPTY));
    public static final int PAGE_SIZE = P.getInt("page.size", 20);
    public static final char[] VERIFY_CODE = P.getString("verify.code", "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray();
    public static final int VERIFY_LENGTH = P.getInt("verify.length", 4);
    public static final boolean MAIN = P.getBoolean("main", true);
    public static final boolean INIT = P.getBoolean("init", true);
    public static final boolean SCHEDULE = P.getBoolean("schedule", true);
    private static final String DEFAULT_PACKAGES = "com.weicoder";
    public static final String PACKAGES = CommonParams.getPackages("");
    public static final String[] CLASS_NAMES = P.getStringArray("class.names", new String[]{"Action", "Service", "Dao", "Job", "Cache", "Impl", "Http"});

    public static boolean power(String name) {
        return P.getBoolean("init.power." + name, true);
    }

    public static String getPackages(String name) {
        String pack = P.getString(P.getKey("", name, "packages"));
        if (U.E.isEmpty(pack) || DEFAULT_PACKAGES.equals(pack)) {
            return DEFAULT_PACKAGES;
        }
        return "com.weicoder," + pack;
    }

    public static int getScheduledPool(String name) {
        return P.getInt(P.getKey("scheduled", name, "pool"), C.O.CPU_NUM);
    }

    public static boolean getScheduledDaemon(String name) {
        return P.getBoolean(P.getKey("scheduled", name, "daemon"), true);
    }

    public static int getExecutorPool(String name) {
        return P.getInt(P.getKey("executor", name, "pool"), C.O.CPU_NUM);
    }

    public static boolean getExecutorDaemon(String name) {
        return P.getBoolean(P.getKey("executor", name, "daemon"), true);
    }
}

