/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.params;

import com.weicoder.common.config.Config;
import com.weicoder.common.config.ConfigFactory;
import com.weicoder.common.params.P;
import com.weicoder.common.util.U;
import java.util.List;

public sealed class Params
permits P {
    private static final Config CONFIG = Params.getConfig("config");

    public static final Config getConfig() {
        return CONFIG;
    }

    public static final Config getConfig(String name) {
        return ConfigFactory.getConfig(name);
    }

    public static List<String> getList(String key, List<String> defaultValue) {
        return CONFIG.getList(key, defaultValue);
    }

    public static String[] getStringArray(String key, String[] defaultValue) {
        return CONFIG.getStringArray(key, defaultValue);
    }

    public static String getString(String key) {
        return CONFIG.getString(key);
    }

    public static String getString(String key, String defaultValue) {
        return CONFIG.getString(key, defaultValue);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return CONFIG.getBoolean(key, defaultValue);
    }

    public static int getInt(String key) {
        return CONFIG.getInt(key);
    }

    public static int getInt(String key, int defaultValue) {
        return CONFIG.getInt(key, defaultValue);
    }

    public static byte getByte(String key) {
        return CONFIG.getByte(key);
    }

    public static byte getByte(String key, byte defaultValue) {
        return CONFIG.getByte(key, defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        return CONFIG.getLong(key, defaultValue);
    }

    public static short getShort(String key, short defaultValue) {
        return CONFIG.getShort(key, defaultValue);
    }

    public static String getKey(String name, String suffix) {
        return Params.getKey("", name, suffix);
    }

    public static String getKey(String prefix, String name, String suffix) {
        StringBuilder sb = new StringBuilder(prefix);
        if (U.E.isNotEmpty(prefix)) {
            sb.append(".");
        }
        if (U.E.isNotEmpty(name)) {
            sb.append(name).append(".");
        }
        if (U.E.isNotEmpty(suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static boolean exists(String key) {
        return CONFIG.exists(key);
    }
}

