/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.queue;

import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.thread.T;
import com.weicoder.common.util.U;
import java.util.Collection;
import java.util.Queue;

public class AsynQueue<E> {
    private static final Log LOG = LogFactory.getLog(AsynQueue.class);
    private Queue<E> queue;

    public AsynQueue(Queue<E> queue, Calls.EoV<E> callback, long time) {
        this.queue = queue;
        T.S.delay(() -> {
            int n;
            if (queue.isEmpty()) {
                return;
            }
            U.D.dura();
            for (n = 0; U.E.isNotEmpty(queue) && n < 10000; ++n) {
                callback.call(queue.poll());
            }
            if (n > 0) {
                LOG.debug("AsynQueue run n={} time={}", n, U.D.dura());
            }
        }, time);
    }

    public boolean add(E e) {
        return this.queue.add(e);
    }

    public boolean addAll(Collection<? extends E> c) {
        return this.queue.addAll(c);
    }

    public Queue<E> queue() {
        return this.queue;
    }
}

