/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.queue;

import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.lang.W;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import com.weicoder.common.thread.T;
import com.weicoder.common.util.U;
import java.util.Collection;
import java.util.List;
import java.util.Queue;

public class AsynQueueList<E> {
    private static final Log LOG = LogFactory.getLog(AsynQueueList.class);
    private Queue<E> queue;

    public AsynQueueList(Queue<E> queue, Calls.LoV<E> callback, long time) {
        this.queue = queue;
        T.S.delay(() -> {
            if (queue.isEmpty()) {
                return;
            }
            int n = 0;
            long c = U.D.now();
            List result = W.L.list();
            while (U.E.isNotEmpty(queue) && n < 10000) {
                LOG.trace("AsynQueueList add i={} add={}", ++n, result.add(queue.poll()));
            }
            if (n > 0) {
                callback.call(result);
                LOG.debug("AsynQueueList run size={} time={}", n, U.D.now() - c);
            }
        }, time);
    }

    public boolean add(E e) {
        return this.queue.add(e);
    }

    public boolean addAll(Collection<? extends E> c) {
        return this.queue.addAll(c);
    }
}

