/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.socket;

import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.io.I;
import com.weicoder.common.log.Logs;
import com.weicoder.common.thread.T;
import com.weicoder.common.util.U;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;

public final class TcpServers {
    public static void aio(int port, Calls.EoR<byte[], byte[]> call) {
        T.start(() -> {
            try {
                AsynchronousServerSocketChannel socket = AsynchronousServerSocketChannel.open();
                try {
                    socket.bind(new InetSocketAddress(port));
                    Logs.debug("aio socket bind is port={} open={}", port, socket.isOpen());
                    while (true) {
                        try {
                            while (true) {
                                AsynchronousSocketChannel asc = socket.accept().get();
                                long time = System.currentTimeMillis();
                                byte[] b = (byte[])call.call(I.A.read(asc, false));
                                if (U.E.isNotEmpty(b)) {
                                    I.A.write(asc, b, false);
                                    asc.shutdownOutput();
                                }
                                Logs.info("aio socket accept end time={} channel={}", U.D.diff(time), asc);
                            }
                        }
                        catch (Exception e) {
                            Logs.error(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Logs.error(e);
                return;
            }
        });
    }

    public static void nio(int port, Calls.EoR<byte[], byte[]> call) {
        T.start(() -> {
            try {
                ServerSocketChannel socket = ServerSocketChannel.open();
                try {
                    socket.bind(new InetSocketAddress(port));
                    Logs.debug("nio socket bind is port={} open={}", port, socket.isOpen());
                    while (true) {
                        try {
                            while (true) {
                                SocketChannel sc = socket.accept();
                                long time = U.D.now();
                                byte[] b = (byte[])call.call(I.C.read(sc, false));
                                if (U.E.isNotEmpty(b)) {
                                    I.C.write((WritableByteChannel)sc, b, false);
                                    sc.shutdownOutput();
                                }
                                Logs.info("nio socket accept end time={} channel={}", U.D.diff(time), sc);
                            }
                        }
                        catch (Exception e) {
                            Logs.error(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Logs.error(e);
                return;
            }
        });
    }

    public static void bio(int port, Calls.EoR<byte[], byte[]> call) {
        T.start(() -> {
            try {
                ServerSocket socket = new ServerSocket(port);
                try {
                    Logs.debug("bio socket bind is port={} bound={} close={}", port, socket.isBound(), socket.isClosed());
                    while (true) {
                        try {
                            while (true) {
                                Socket sc = socket.accept();
                                long time = System.currentTimeMillis();
                                byte[] b = (byte[])call.call(I.read(sc.getInputStream(), false));
                                if (U.E.isNotEmpty(b)) {
                                    I.write(sc.getOutputStream(), b, false);
                                    sc.shutdownOutput();
                                }
                                Logs.info("bio socket accept end time={} channel={}", U.D.diff(time), sc);
                            }
                        }
                        catch (Exception e) {
                            Logs.error(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Logs.error(e);
                return;
            }
        });
    }

    private TcpServers() {
    }
}

