/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.statics;

import com.weicoder.common.lang.W;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class Randoms {
    private static final Random RANDOM = new Random();
    private static final Random SECURE = new SecureRandom();

    public static Random current() {
        return ThreadLocalRandom.current();
    }

    public static Random random() {
        return RANDOM;
    }

    public static Random secure() {
        return SECURE;
    }

    public static byte[] nextBytes(int len, int m, int n) {
        return Randoms.nextBytes(Randoms.random(), len, m, n);
    }

    public static byte[] nextBytes(Random r, int len, int m, int n) {
        return Randoms.nextBytes(r, len, m, n, false);
    }

    public static byte[] nextBytes(Random r, int len, int s, int e, boolean is) {
        byte[] b = new byte[len];
        HashSet<Byte> set = W.S.set(len);
        for (int i = 0; i < len; ++i) {
            byte t = (byte)r.nextInt(s, e);
            if (!is && set.contains(t)) {
                --i;
                continue;
            }
            b[i] = t;
            set.add(b[i]);
        }
        set.clear();
        return b;
    }

    public static List<byte[]> nextBytes(Random r, int len, int s, int e, int n, boolean is) {
        if (s < -128) {
            s = -128;
        }
        if (e > 127) {
            e = 128;
        }
        List<byte[]> list = W.L.list(n);
        for (int i = 0; i < n; ++i) {
            list.add(Randoms.nextBytes(r, len, s, e, is));
        }
        return list;
    }

    public static int nextInt() {
        return Randoms.random().nextInt();
    }

    public static int nextInt(int n) {
        return Randoms.random().nextInt(n);
    }

    public static int nextInt(int m, int n) {
        return Randoms.random().nextInt(m, n);
    }

    public static double nextDouble() {
        return Randoms.random().nextDouble();
    }

    public static float nextFloat() {
        return Randoms.random().nextFloat();
    }

    public static long nextLong() {
        return Randoms.random().nextLong();
    }

    public static String random(int len) {
        StringBuilder veryfy = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int n = Randoms.nextInt(48, 123);
            if (n > 91 && n < 97 || n > 57 && n < 65) {
                n += Randoms.nextInt(7, 16);
            }
            veryfy.append((char)n);
        }
        return veryfy.toString();
    }
}

