/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.thread;

import com.weicoder.common.interfaces.Calls;
import com.weicoder.common.lang.W;
import com.weicoder.common.log.Logs;
import com.weicoder.common.thread.T;
import com.weicoder.common.thread.concurrent.factory.DaemonThreadFactory;
import com.weicoder.common.thread.concurrent.factory.ExecutorFactory;
import com.weicoder.common.util.U;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public sealed class ExecutorUtil
permits T.E {
    private static final ExecutorFactory FACTORY = new ExecutorFactory();
    private static final List<Runnable> RUNNABLES = W.L.list();
    private static final List<Callable<Object>> CALLABLES = W.L.list();

    public static void newExecute(Runnable command) {
        ExecutorUtil.newSingle().execute(command);
    }

    public static ExecutorService newSingle() {
        return Executors.newSingleThreadExecutor(DaemonThreadFactory.INSTANCE);
    }

    public static ExecutorService newPool(int pool, boolean daemon) {
        return FACTORY.newPool(pool, daemon);
    }

    public static void execute(Runnable command) {
        ExecutorUtil.pool().execute(command);
    }

    public static ExecutorService pool() {
        return ExecutorUtil.pool("");
    }

    public static ExecutorService pool(String name) {
        return (ExecutorService)FACTORY.getInstance(name);
    }

    public static void addR(Runnable task) {
        RUNNABLES.add(task);
    }

    public static void addC(Callable<Object> task) {
        CALLABLES.add(task);
    }

    public static void execute() {
        ExecutorUtil.execute(W.L.copy(RUNNABLES));
    }

    public static int size() {
        return RUNNABLES.size() + CALLABLES.size();
    }

    public static List<Object> submit() {
        return ExecutorUtil.submit(W.L.copy(CALLABLES));
    }

    public static void execute(List<Runnable> tasks) {
        int size = tasks.size();
        Logs.info("execute start tasks={} time={}", size, U.D.dura());
        CountDownLatch latch = new CountDownLatch(size);
        tasks.forEach(r -> ExecutorUtil.pool().execute(() -> {
            r.run();
            latch.countDown();
        }));
        try {
            latch.await();
            Logs.info("execute end tasks={} time={}", size, U.D.dura());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static <R> List<R> submit(List<Callable<R>> tasks) {
        return ExecutorUtil.submit(tasks, 0L);
    }

    public static <R> List<R> submit(List<Callable<R>> tasks, long timeout) {
        int len = tasks.size();
        List list = W.L.list(len);
        List ls = W.L.list(len);
        tasks.forEach(task -> list.add(ExecutorUtil.pool().submit(task)));
        list.forEach(f -> {
            try {
                if (timeout > 0L) {
                    ls.add(f.get(timeout, TimeUnit.MILLISECONDS));
                } else {
                    ls.add(f.get());
                }
            }
            catch (Exception e) {
                Logs.warn(e);
            }
        });
        return ls;
    }

    public static void works(Calls.EoV<Long> call) {
        ExecutorUtil.works(new AtomicLong(), call);
    }

    public static void works(AtomicLong sequence, Calls.EoV<Long> call) {
        ExecutorUtil.works(ExecutorUtil.newSingle(), sequence, call);
    }

    public static void works(int pool, Calls.EoV<Long> call) {
        ExecutorUtil.works(pool, new AtomicLong(), call);
    }

    public static void works(int pool, AtomicLong sequence, Calls.EoV<Long> call) {
        ExecutorService es = ExecutorUtil.newPool(pool, true);
        for (int i = 0; i < pool; ++i) {
            ExecutorUtil.works(es, sequence, call);
        }
    }

    public static void works(ExecutorService es, AtomicLong sequence, Calls.EoV<Long> call) {
        es.execute(() -> {
            while (true) {
                U.D.dura();
                call.call(sequence.getAndAdd(1L));
                Logs.debug("works sequence={} time={}", sequence, U.D.dura());
            }
        });
    }
}

