/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.thread;

import com.weicoder.common.log.Logs;
import com.weicoder.common.thread.T;
import com.weicoder.common.thread.concurrent.factory.DaemonThreadFactory;
import com.weicoder.common.thread.concurrent.factory.ScheduledFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public sealed class ScheduledUtil
permits T.S {
    private static final ScheduledFactory FACTORY = new ScheduledFactory();

    public static ScheduledFuture<?> newDelay(Runnable command, long initialDelay, long delay) {
        return ScheduledUtil.newSingle().scheduleWithFixedDelay(command, initialDelay, delay, TimeUnit.MICROSECONDS);
    }

    public static ScheduledFuture<?> newRate(Runnable command, int initialDelay, int delay) {
        return ScheduledUtil.newSingle().scheduleWithFixedDelay(command, initialDelay, delay, TimeUnit.SECONDS);
    }

    public static ScheduledExecutorService newSingle() {
        return Executors.newSingleThreadScheduledExecutor(DaemonThreadFactory.INSTANCE);
    }

    public static ScheduledExecutorService newPool(int pool, boolean daemon) {
        return FACTORY.newPool(pool, daemon);
    }

    public static ScheduledExecutorService pool() {
        return ScheduledUtil.pool("");
    }

    public static ScheduledExecutorService pool(String name) {
        return (ScheduledExecutorService)FACTORY.getInstance(name);
    }

    public static ScheduledFuture<?> rate(Runnable command, long period) {
        return ScheduledUtil.rate(command, 0L, period, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> rate(Runnable command, int period) {
        return ScheduledUtil.rate(command, (long)period * 1000L);
    }

    public static ScheduledFuture<?> rate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return ScheduledUtil.rate("", command, initialDelay, period, unit);
    }

    public static ScheduledFuture<?> rate(String name, Runnable command, long period) {
        return ScheduledUtil.rate(name, command, period, period, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> rate(String name, Runnable command, int period) {
        return ScheduledUtil.rate(name, command, (long)period * 1000L);
    }

    public static ScheduledFuture<?> rate(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        Logs.debug("ScheduledUtile rate name={} command={},initialDelay={},period={},unit={}", new Object[]{name, command, initialDelay, period, unit});
        return ScheduledUtil.pool(name).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public static ScheduledFuture<?> delay(Runnable command, long delay) {
        return ScheduledUtil.delay(command, 0L, delay, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> delay(Runnable command, int delay) {
        return ScheduledUtil.delay(command, (long)delay * 1000L);
    }

    public static ScheduledFuture<?> delay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return ScheduledUtil.delay("", command, initialDelay, delay, unit);
    }

    public static ScheduledFuture<?> delay(String name, Runnable command, long delay) {
        return ScheduledUtil.delay(name, command, 0L, delay, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> delay(String name, Runnable command, int delay) {
        return ScheduledUtil.delay(name, command, (long)delay * 1000L);
    }

    public static ScheduledFuture<?> delay(String name, Runnable command, long initialDelay, long delay, TimeUnit unit) {
        Logs.debug("ScheduledUtile rate name={} command={},initialDelay={},delay={},unit={}", new Object[]{name, command, initialDelay, delay, unit});
        return ScheduledUtil.pool(name).scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

