/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.token;

import com.weicoder.common.binary.ByteArray;
import com.weicoder.common.crypto.Decrypts;
import com.weicoder.common.crypto.Encrypts;
import com.weicoder.common.lang.W;
import com.weicoder.common.params.P;
import com.weicoder.common.util.U;
import java.util.Set;

public final class TokenBean
implements ByteArray {
    private long id;
    private int time;
    private String ip;
    private String server;
    private boolean ban;
    private byte b;
    private short sign;
    private boolean valid;
    private String token;

    TokenBean() {
    }

    TokenBean(String token) {
        this.token = token;
        this.array(Decrypts.token(token));
    }

    TokenBean(long id, String ip, int time, boolean ban, byte b) {
        this.id = id;
        this.time = U.D.getTime() + time;
        this.ip = ip;
        this.server = U.IP.SERVER_IP;
        this.ban = ban;
        this.b = b;
        this.sign = P.C.TOKEN_SIGN;
        this.token = Encrypts.token(this.array());
        this.valid = true;
    }

    public String getDate() {
        return U.D.toString(this.time);
    }

    public boolean isLogin() {
        return this.id != 0L && !this.isExpire() && this.isValid() && this.isSign() && !this.isBan();
    }

    public boolean isSign() {
        return this.sign == P.C.TOKEN_SIGN;
    }

    public boolean isBan() {
        return this.ban;
    }

    public boolean isServer() {
        return P.C.TOKEN_SERVERS.contains(this.server);
    }

    public boolean isServer(Set<String> servers) {
        return servers.contains(this.server);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isExpire() {
        return this.time - U.D.getTime() < 0;
    }

    public long getId() {
        return this.id;
    }

    public int getTime() {
        return this.time;
    }

    public String getIp() {
        return this.ip;
    }

    public String getToken() {
        return this.token;
    }

    public String toString() {
        return this.token;
    }

    @Override
    public byte[] array() {
        return W.B.toBytes(this.id, this.time, U.IP.encode(this.ip), U.IP.encode(this.server), this.ban, this.b, this.sign);
    }

    @Override
    public TokenBean array(byte[] b) {
        if (U.E.isNotEmpty(b)) {
            this.id = W.B.toLong(b);
            this.time = W.B.toInt(b, 8);
            this.ip = U.IP.decode(W.B.toInt(b, 12));
            this.server = U.IP.decode(W.B.toInt(b, 16));
            this.ban = W.B.toBoolean(b, 20);
            this.b = W.B.toByte(b, 21);
            this.sign = W.B.toShort(b, 22);
            this.valid = this.id != 0L;
        }
        return this;
    }
}

