/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.lang.W;
import com.weicoder.common.util.U;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public sealed class ArrayUtil
permits U.A {
    public static Object array(String s, Class<?> c) {
        return ArrayUtil.array(s, "&", c);
    }

    public static Object array(String s, String sepa, Class<?> c) {
        Class<?> type;
        if (U.E.isEmpty(s) || c == null) {
            return null;
        }
        String[] t = U.S.split(s, sepa);
        Class<?> clazz = type = c.isArray() ? c.getComponentType() : c;
        if (String.class.equals(type)) {
            return t;
        }
        Object arr = Array.get(type, t.length);
        for (int i = 0; i < t.length; ++i) {
            Array.set(arr, i, W.C.to(t[i], type));
        }
        return arr;
    }

    public static boolean isArray(Object obj) {
        return U.E.isNotEmpty(obj) && obj.getClass().isArray();
    }

    @SafeVarargs
    public static <E> List<E> toList(E ... e) {
        return Arrays.asList(e);
    }

    public static <E> void copy(E[] src, E[] dest) {
        ArrayUtil.copy(src, dest, 0);
    }

    public static <E> void copy(E[] src, E[] dest, int pos) {
        ArrayUtil.copy(src, pos, dest, pos, src.length);
    }

    public static <E> void copy(E[] src, int srcPos, E[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public static Integer[] toInteger(int[] n) {
        Integer[] t = new Integer[n.length];
        for (int i = 0; i < n.length; ++i) {
            t[i] = n[i];
        }
        return t;
    }

    public static Integer[] toInteger(String[] s) {
        Integer[] t = new Integer[s.length];
        for (int i = 0; i < s.length; ++i) {
            t[i] = W.C.toInt(s[i]);
        }
        return t;
    }

    public static int[] toInt(Integer[] n) {
        int[] t = new int[n.length];
        for (int i = 0; i < n.length; ++i) {
            t[i] = n[i];
        }
        return t;
    }

    public static String[] toStringArray(Integer[] n) {
        String[] t = new String[n.length];
        for (int i = 0; i < n.length; ++i) {
            t[i] = W.C.toString(n[i]);
        }
        return t;
    }

    public static String[] toStringArray(Serializable[] a) {
        String[] t = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            t[i] = W.C.toString(a[i]);
        }
        return t;
    }

    public static String[] toStringArray(Object[] a) {
        String[] t = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            t[i] = W.C.toString(a[i]);
        }
        return t;
    }

    public static String toString(Object[] a) {
        return Arrays.toString(a).replaceAll("[\\[\\]]", "");
    }

    public static <E> E[] add(E[] one, E[] two) {
        return ArrayUtil.add(one, two, two.length);
    }

    public static <E> E[] add(E[] one, E[] two, int twoLength) {
        return ArrayUtil.add(one, 0, one.length, two, 0, twoLength);
    }

    public static <E> E[] add(E[] one, int onePos, int oneLength, E[] two, int twoPos, int twoLength) {
        ?[] result = ArrayUtil.getArray(one.getClass(), oneLength + twoLength);
        ArrayUtil.copy(one, onePos, result, 0, oneLength);
        ArrayUtil.copy(two, twoPos, result, oneLength, twoLength);
        return result;
    }

    public static <E> E[] getArray(Class<E> clazz, int length) {
        return (Object[])Array.newInstance(clazz, length);
    }

    @SafeVarargs
    public static <E> E[] getArray(E ... e) {
        return e;
    }
}

