/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.lang.W;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.U;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public sealed class BeanUtil
permits U.B {
    public static <T> T copy(Object source, Class<T> entity) {
        return BeanUtil.copy(source, U.C.newInstance(entity, new Class[0]));
    }

    public static <T> T copy(Object source, T target) {
        if (source == null || target == null) {
            return target;
        }
        if (source instanceof Map) {
            return BeanUtil.copy((Map)source, target);
        }
        Map map = null;
        if (target instanceof Map) {
            map = (Map)target;
        }
        for (Field field : BeanUtil.getFields(source.getClass())) {
            try {
                if (field.isSynthetic()) continue;
                if (map == null) {
                    BeanUtil.setFieldValue(target, BeanUtil.getField(target, field.getName()), BeanUtil.getFieldValue(source, field));
                    continue;
                }
                map.put(field.getName(), BeanUtil.getFieldValue(source, field));
            }
            catch (Exception e) {
                Logs.error(e);
            }
        }
        return target;
    }

    public static <T> T copy(Map<?, ?> map, T dest) {
        BeanUtil.getFields(dest.getClass()).forEach(field -> {
            try {
                if (!field.isSynthetic()) {
                    String name = field.getName();
                    BeanUtil.setFieldValue(dest, BeanUtil.getField(dest, name), map.get(name));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return dest;
    }

    public static <T> T copy(Map<?, ?> map, Class<T> dest) {
        return BeanUtil.copy(map, U.C.newInstance(dest, new Class[0]));
    }

    public static <T> List<T> copy(List<Map<String, Object>> list, Class<T> dest) {
        int size = list.size();
        List<T> ls = W.L.list(size);
        for (int i = 0; i < size; ++i) {
            ls.add(BeanUtil.copy(list.get(i), dest));
        }
        return ls;
    }

    public static List<Object> getFieldValues(Collection<?> list, String fieldName) {
        if (U.E.isEmpty(list)) {
            return W.L.empty();
        }
        List<Object> ls = W.L.list(list.size());
        list.forEach(e -> {
            Object val = BeanUtil.getFieldValue(e, fieldName);
            if (val instanceof Collection) {
                ls.addAll((Collection)val);
            } else {
                ls.add(val);
            }
        });
        return ls;
    }

    public static List<Object> getFieldValues(Object obj) {
        List<Field> fields = BeanUtil.getFields(obj.getClass());
        List<Object> values = W.L.list(fields.size());
        fields.forEach(field -> values.add(BeanUtil.getFieldValue(obj, field.getName())));
        return values;
    }

    public static Object getFieldValue(Object object, String fieldName) {
        if (fieldName.indexOf(".") > -1) {
            return BeanUtil.getFieldValue(BeanUtil.getFieldValue(object, U.S.subStringEnd(fieldName, ".")), U.S.subString(fieldName, "."));
        }
        Field field = BeanUtil.getField(object, fieldName);
        if (U.E.isEmpty(field)) {
            return null;
        }
        try {
            return BeanUtil.makeAccessible(field).get(object);
        }
        catch (IllegalAccessException e) {
            Logs.error(e);
            return null;
        }
    }

    public static Object getFieldValue(Object object, Field field) {
        if (object == null || field == null) {
            return null;
        }
        try {
            return BeanUtil.makeAccessible(field).get(object);
        }
        catch (IllegalAccessException e) {
            Logs.error(e);
            return null;
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        BeanUtil.setFieldValue(object, BeanUtil.getField(object, fieldName), value);
    }

    public static void setFieldValue(Object object, int i, Object value) {
        BeanUtil.setFieldValue(object, BeanUtil.getField(object, i), value);
    }

    public static void setFieldValue(Object object, Field field, Object value) {
        if (object == null || field == null || value == null) {
            return;
        }
        try {
            BeanUtil.makeAccessible(field).set(object, W.C.to(value, field.getType()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object invoke(Object obj, Method method, Object ... args) {
        try {
            return BeanUtil.makeAccessible(method).invoke(obj, U.E.isEmpty(args) ? null : args);
        }
        catch (Exception e) {
            Logs.error(e, "invoke method={} args={} params={}", method.getName(), Arrays.toString(args), Arrays.toString(method.getParameters()));
            return null;
        }
    }

    public static Object invoke(Object object, String name) {
        return BeanUtil.invoke(object, name, null, null);
    }

    public static Object invoke(Object object, String name, Class<?>[] parameterTypes, Object[] parameters) {
        Class<?> c = null;
        c = object instanceof Class ? (Class<?>)object : object.getClass();
        if (c == null) {
            return null;
        }
        try {
            return BeanUtil.getMethod(c, name, parameterTypes).invoke(object, parameters);
        }
        catch (Exception e) {
            Logs.error(e);
            return null;
        }
    }

    public static Field getField(Object object, int i) {
        return BeanUtil.getField(object.getClass(), i);
    }

    public static Field getField(Class<?> clazz, int i) {
        if (clazz == null || i < 0) {
            return null;
        }
        try {
            return clazz.getDeclaredFields()[i];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Field getField(Object object, String name) {
        return BeanUtil.getField(object.getClass(), name);
    }

    public static Field getField(Class<?> clazz, String name) {
        if (clazz == null || U.E.isEmpty(name)) {
            return null;
        }
        if (name.indexOf(".") > -1) {
            return BeanUtil.getField((Object)BeanUtil.getField(clazz, U.S.subStringEnd(name, ".")), U.S.subString(name, "."));
        }
        Field f = null;
        while (clazz != Object.class && f == null) {
            try {
                f = clazz.getDeclaredField(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return f;
    }

    public static List<Field> getFields(Class<?> clazz) {
        if (U.E.isEmpty(clazz)) {
            return W.L.empty();
        }
        List<Field> fields = W.L.list();
        while (clazz != Object.class) {
            try {
                fields.addAll(W.L.list(clazz.getDeclaredFields()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static Method getMethod(Object obj, String name, Class<?> ... parameterTypes) {
        Class<?> superClass;
        if (obj == null || U.E.isEmpty(name)) {
            return null;
        }
        Method method = null;
        Class<?> clazz = superClass = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        while (superClass != Object.class && method == null) {
            try {
                method = superClass.getDeclaredMethod(name, parameterTypes);
            }
            catch (Exception exception) {
                // empty catch block
            }
            superClass = superClass.getSuperclass();
        }
        return method;
    }

    private static Field makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
        return field;
    }

    private static Method makeAccessible(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
        return method;
    }
}

