/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.lang.W;
import com.weicoder.common.util.U;
import java.math.BigDecimal;
import java.math.RoundingMode;

public sealed class MathUtil
permits U.M {
    private static final RoundingMode ROUND = RoundingMode.HALF_UP;

    public static BigDecimal add(Object ... values) {
        BigDecimal result = BigDecimal.ZERO;
        for (int i = 0; i < values.length; ++i) {
            result = result.add(W.C.toBigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal subtract(Object v1, Object v2) {
        return MathUtil.scale(v1).subtract(W.C.toBigDecimal(v2));
    }

    public static BigDecimal subtract(Object v1, Object v2, int scale) {
        return MathUtil.subtract(v1, v2).setScale(scale, ROUND);
    }

    public static BigDecimal multiply(Object ... values) {
        BigDecimal result = BigDecimal.ONE;
        for (int i = 0; i < values.length; ++i) {
            result = result.multiply(W.C.toBigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal divide(Object v1, Object v2) {
        return MathUtil.divide(v1, v2, 2);
    }

    public static BigDecimal divide(Object v1, Object v2, int scale) {
        return W.C.toBigDecimal(v2).equals(BigDecimal.ZERO) ? BigDecimal.ZERO : MathUtil.scale(v1, scale).divide(MathUtil.scale(v2, scale), scale, ROUND);
    }

    public static BigDecimal remainder(Object v1, Object v2) {
        return MathUtil.remainder(v1, v2, 2);
    }

    public static BigDecimal remainder(Object v1, Object v2, int scale) {
        return MathUtil.scale(v1, scale).remainder(MathUtil.scale(v2, scale));
    }

    public static BigDecimal scale(Object v) {
        return MathUtil.scale(v, 2);
    }

    public static BigDecimal scale(Object v, int scale) {
        return W.C.toBigDecimal(v).setScale(scale, ROUND);
    }

    public static String take(String v) {
        return v.indexOf(",") == -1 ? v : v.replaceAll(",", "");
    }

    public static String toString(Object val) {
        return W.C.toBigDecimal(val).toPlainString();
    }
}

