/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.constants.C;
import com.weicoder.common.io.I;
import com.weicoder.common.lang.W;
import com.weicoder.common.util.U;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

public sealed class ResourceUtil
permits U.R {
    public static File newFile(String name) {
        try {
            return new File(ResourceUtil.getResource(name).toURI());
        }
        catch (Exception e) {
            return I.F.newFile(C.O.USER_DIR + "/" + name);
        }
    }

    public static URL getResource(String resourceName) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null && (url = ClassLoader.getSystemClassLoader().getResource(resourceName)) == null) {
            url = ClassLoader.getSystemResource(resourceName);
        }
        if (url == null && U.E.isNotEmpty(resourceName) && !resourceName.startsWith("/")) {
            return ResourceUtil.getResource("/" + resourceName);
        }
        try {
            return url == null ? URI.create("http://").toURL() : url;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static List<URL> getResources(String resourceName) {
        List<URL> urls = W.L.list();
        try {
            Enumeration<URL> u = Thread.currentThread().getContextClassLoader().getResources(resourceName);
            while (u.hasMoreElements()) {
                urls.add(u.nextElement());
            }
            if (U.E.isEmpty(urls)) {
                u = ClassLoader.getSystemClassLoader().getResources(resourceName);
                while (u.hasMoreElements()) {
                    urls.add(u.nextElement());
                }
                if (U.E.isEmpty(urls)) {
                    u = ClassLoader.getSystemResources(resourceName);
                    while (u.hasMoreElements()) {
                        urls.add(u.nextElement());
                    }
                }
            }
            if (U.E.isEmpty(urls) && !U.E.isEmpty(resourceName) && !resourceName.startsWith("/")) {
                return ResourceUtil.getResources("/" + resourceName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    public static InputStream loadResource(String name) {
        InputStream in = ClassLoader.getSystemResourceAsStream(name);
        if (in == null && (in = Thread.currentThread().getContextClassLoader().getResourceAsStream(name)) == null) {
            in = ClassLoader.getSystemClassLoader().getResourceAsStream(name);
        }
        return in;
    }
}

