/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public abstract class AbstractTDigest
extends TDigest {
    private static final long serialVersionUID = 1L;
    final Random gen = new Random();
    boolean recordAllData = false;

    static double weightedAverage(double x1, double w1, double x2, double w2) {
        if (x1 <= x2) {
            return AbstractTDigest.weightedAverageSorted(x1, w1, x2, w2);
        }
        return AbstractTDigest.weightedAverageSorted(x2, w2, x1, w1);
    }

    private static double weightedAverageSorted(double x1, double w1, double x2, double w2) {
        assert (x1 <= x2);
        double x = (x1 * w1 + x2 * w2) / (w1 + w2);
        return Math.max(x1, Math.min(x, x2));
    }

    static double interpolate(double x, double x0, double x1) {
        return (x - x0) / (x1 - x0);
    }

    static void encode(ByteBuffer buf, int n) {
        int k = 0;
        while (n < 0 || n > 127) {
            byte b = (byte)(0x80 | 0x7F & n);
            buf.put(b);
            n >>>= 7;
            if (++k < 6) continue;
            throw new IllegalStateException("Size is implausibly large");
        }
        buf.put((byte)n);
    }

    static int decode(ByteBuffer buf) {
        byte v = buf.get();
        int z = 0x7F & v;
        int shift = 7;
        while ((v & 0x80) != 0) {
            if (shift > 28) {
                throw new IllegalStateException("Shift too large in decode");
            }
            v = buf.get();
            z += (v & 0x7F) << shift;
            shift += 7;
        }
        return z;
    }

    abstract void add(double var1, int var3, Centroid var4);

    static double quantile(double index, double previousIndex, double nextIndex, double previousMean, double nextMean) {
        double delta = nextIndex - previousIndex;
        double previousWeight = (nextIndex - index) / delta;
        double nextWeight = (index - previousIndex) / delta;
        return previousMean * previousWeight + nextMean * nextWeight;
    }

    @Override
    public TDigest recordAllData() {
        this.recordAllData = true;
        return this;
    }

    @Override
    public boolean isRecording() {
        return this.recordAllData;
    }

    @Override
    public void add(double x) {
        this.add(x, 1);
    }

    @Override
    public void add(TDigest other) {
        ArrayList<Centroid> tmp = new ArrayList<Centroid>();
        for (Centroid centroid : other.centroids()) {
            tmp.add(centroid);
        }
        Collections.shuffle(tmp, this.gen);
        for (Centroid centroid : tmp) {
            this.add(centroid.mean(), centroid.count(), centroid);
        }
    }

    protected Centroid createCentroid(double mean, int id) {
        return new Centroid(mean, id, this.recordAllData);
    }
}

