/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.AbstractTDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.Sort;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MergingDigest
extends AbstractTDigest {
    private static final long serialVersionUID = 1L;
    private final double compression;
    private int lastUsedCell;
    private double totalWeight = 0.0;
    private final double[] weight;
    private final double[] mean;
    private List<List<Double>> data = null;
    private double unmergedWeight = 0.0;
    private int tempUsed = 0;
    private final double[] tempWeight;
    private final double[] tempMean;
    private List<List<Double>> tempData = null;
    private final int[] order;
    private static boolean usePieceWiseApproximation = true;
    private static boolean useWeightLimit = true;

    public MergingDigest(double compression) {
        this(compression, -1);
    }

    public MergingDigest(double compression, int bufferSize) {
        this(compression, bufferSize, -1);
    }

    public MergingDigest(double compression, int bufferSize, int size) {
        if (size == -1) {
            size = (int)(2.0 * Math.ceil(compression));
            if (useWeightLimit) {
                size += 10;
            }
        }
        if (bufferSize == -1) {
            bufferSize = (int)(5.0 * Math.ceil(compression));
        }
        this.compression = compression;
        this.weight = new double[size];
        this.mean = new double[size];
        this.tempWeight = new double[bufferSize];
        this.tempMean = new double[bufferSize];
        this.order = new int[bufferSize];
        this.lastUsedCell = 0;
    }

    @Override
    public TDigest recordAllData() {
        super.recordAllData();
        this.data = new ArrayList<List<Double>>();
        this.tempData = new ArrayList<List<Double>>();
        return this;
    }

    @Override
    void add(double x, int w, Centroid base) {
        this.add(x, w, base.data());
    }

    @Override
    public void add(double x, int w) {
        this.add(x, w, (List<Double>)null);
    }

    private void add(double x, int w, List<Double> history) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("Cannot add NaN to t-digest");
        }
        if (this.tempUsed >= this.tempWeight.length - this.lastUsedCell - 1) {
            this.mergeNewValues();
        }
        int where = this.tempUsed++;
        this.tempWeight[where] = w;
        this.tempMean[where] = x;
        this.unmergedWeight += (double)w;
        if (this.data != null) {
            if (this.tempData == null) {
                this.tempData = new ArrayList<List<Double>>();
            }
            while (this.tempData.size() <= where) {
                this.tempData.add(new ArrayList());
            }
            if (history == null) {
                history = Collections.singletonList(x);
            }
            this.tempData.get(where).addAll(history);
        }
    }

    private void add(double[] m, double[] w, int count, List<List<Double>> data) {
        if (m.length != w.length) {
            throw new IllegalArgumentException("Arrays not same length");
        }
        if (m.length < count + this.lastUsedCell) {
            double[] m1 = new double[count + this.lastUsedCell];
            System.arraycopy(m, 0, m1, 0, count);
            m = m1;
            double[] w1 = new double[count + this.lastUsedCell];
            System.arraycopy(w, 0, w1, 0, count);
            w = w1;
        }
        double total = 0.0;
        for (int i = 0; i < count; ++i) {
            total += w[i];
        }
        this.merge(m, w, count, data, null, total);
    }

    @Override
    public void add(List<? extends TDigest> others) {
        if (others.size() == 0) {
            return;
        }
        int size = this.lastUsedCell;
        for (TDigest tDigest : others) {
            tDigest.compress();
            size += tDigest.centroidCount();
        }
        double[] m = new double[size];
        double[] dArray = new double[size];
        ArrayList<List<Double>> data = this.recordAllData ? new ArrayList<List<Double>>() : null;
        int offset = 0;
        for (TDigest tDigest : others) {
            if (tDigest instanceof MergingDigest) {
                MergingDigest md = (MergingDigest)tDigest;
                System.arraycopy(md.mean, 0, m, offset, md.lastUsedCell);
                System.arraycopy(md.weight, 0, dArray, offset, md.lastUsedCell);
                if (data != null) {
                    for (Centroid centroid : tDigest.centroids()) {
                        data.add(centroid.data());
                    }
                }
                offset += md.lastUsedCell;
                continue;
            }
            for (Centroid centroid : tDigest.centroids()) {
                m[offset] = centroid.mean();
                dArray[offset] = centroid.count();
                if (this.recordAllData) {
                    assert (data != null);
                    data.add(centroid.data());
                }
                ++offset;
            }
        }
        this.add(m, dArray, size, data);
    }

    private void mergeNewValues() {
        if (this.unmergedWeight > 0.0) {
            this.merge(this.tempMean, this.tempWeight, this.tempUsed, this.tempData, this.order, this.unmergedWeight);
            this.tempUsed = 0;
            this.unmergedWeight = 0.0;
            if (this.data != null) {
                this.tempData = new ArrayList<List<Double>>();
            }
        }
    }

    private void merge(double[] incomingMean, double[] incomingWeight, int incomingCount, List<List<Double>> incomingData, int[] incomingOrder, double unmergedWeight) {
        System.arraycopy(this.mean, 0, incomingMean, incomingCount, this.lastUsedCell);
        System.arraycopy(this.weight, 0, incomingWeight, incomingCount, this.lastUsedCell);
        incomingCount += this.lastUsedCell;
        if (incomingData != null) {
            for (int i = 0; i < this.lastUsedCell; ++i) {
                assert (this.data != null);
                incomingData.add(this.data.get(i));
            }
            this.data = new ArrayList<List<Double>>();
        }
        if (incomingOrder == null) {
            incomingOrder = new int[incomingCount];
        }
        Sort.sort(incomingOrder, incomingMean, incomingCount);
        this.totalWeight += unmergedWeight;
        double normalizer = this.compression / (Math.PI * this.totalWeight);
        assert (incomingCount > 0);
        this.lastUsedCell = 0;
        this.mean[this.lastUsedCell] = incomingMean[incomingOrder[0]];
        this.weight[this.lastUsedCell] = incomingWeight[incomingOrder[0]];
        double wSoFar = 0.0;
        if (this.data != null) {
            assert (incomingData != null);
            this.data.add(incomingData.get(incomingOrder[0]));
        }
        double k1 = 0.0;
        double wLimit = this.totalWeight * this.integratedQ(k1 + 1.0);
        for (int i = 1; i < incomingCount; ++i) {
            boolean addThis;
            int ix = incomingOrder[i];
            double proposedWeight = this.weight[this.lastUsedCell] + incomingWeight[ix];
            double projectedW = wSoFar + proposedWeight;
            if (useWeightLimit) {
                double z = proposedWeight * normalizer;
                double q0 = wSoFar / this.totalWeight;
                double q2 = (wSoFar + proposedWeight) / this.totalWeight;
                addThis = z * z <= q0 * (1.0 - q0) && z * z <= q2 * (1.0 - q2);
            } else {
                boolean bl = addThis = projectedW <= wLimit;
            }
            if (addThis) {
                int n = this.lastUsedCell;
                this.weight[n] = this.weight[n] + incomingWeight[ix];
                this.mean[this.lastUsedCell] = this.mean[this.lastUsedCell] + (incomingMean[ix] - this.mean[this.lastUsedCell]) * incomingWeight[ix] / this.weight[this.lastUsedCell];
                incomingWeight[ix] = 0.0;
                if (this.data == null) continue;
                while (this.data.size() <= this.lastUsedCell) {
                    this.data.add(new ArrayList());
                }
                assert (incomingData != null);
                assert (this.data.get(this.lastUsedCell) != incomingData.get(ix));
                this.data.get(this.lastUsedCell).addAll((Collection<Double>)incomingData.get(ix));
                continue;
            }
            wSoFar += this.weight[this.lastUsedCell];
            if (!useWeightLimit) {
                k1 = this.integratedLocation(wSoFar / this.totalWeight);
                wLimit = this.totalWeight * this.integratedQ(k1 + 1.0);
            }
            ++this.lastUsedCell;
            this.mean[this.lastUsedCell] = incomingMean[ix];
            this.weight[this.lastUsedCell] = incomingWeight[ix];
            incomingWeight[ix] = 0.0;
            if (this.data == null) continue;
            assert (incomingData != null);
            assert (this.data.size() == this.lastUsedCell);
            this.data.add(incomingData.get(ix));
        }
        ++this.lastUsedCell;
        double sum = 0.0;
        for (int i = 0; i < this.lastUsedCell; ++i) {
            sum += this.weight[i];
        }
        assert (sum == this.totalWeight);
        if (this.totalWeight > 0.0) {
            this.min = Math.min(this.min, this.mean[0]);
            this.max = Math.max(this.max, this.mean[this.lastUsedCell - 1]);
        }
    }

    int checkWeights() {
        return this.checkWeights(this.weight, this.totalWeight, this.lastUsedCell);
    }

    private int checkWeights(double[] w, double total, int last) {
        int badCount = 0;
        int n = last;
        if (w[n] > 0.0) {
            ++n;
        }
        double k1 = 0.0;
        double q = 0.0;
        double left = 0.0;
        String header = "\n";
        for (int i = 0; i < n; ++i) {
            double dq = w[i] / total;
            double k2 = this.integratedLocation(q + dq);
            q += dq / 2.0;
            if (k2 - k1 > 1.0 && w[i] != 1.0) {
                System.out.printf("%sOversize centroid at %d, k0=%.2f, k1=%.2f, dk=%.2f, w=%.2f, q=%.4f, dq=%.4f, left=%.1f, current=%.2f maxw=%.2f\n", header, i, k1, k2, k2 - k1, w[i], q, dq, left, w[i], Math.PI * total / this.compression * Math.sqrt(q * (1.0 - q)));
                header = "";
                ++badCount;
            }
            if (k2 - k1 > 4.0 && w[i] != 1.0) {
                throw new IllegalStateException(String.format("Egregiously oversized centroid at %d, k0=%.2f, k1=%.2f, dk=%.2f, w=%.2f, q=%.4f, dq=%.4f, left=%.1f, current=%.2f, maxw=%.2f\n", i, k1, k2, k2 - k1, w[i], q, dq, left, w[i], Math.PI * total / this.compression * Math.sqrt(q * (1.0 - q))));
            }
            q += dq / 2.0;
            left += w[i];
            k1 = k2;
        }
        return badCount;
    }

    private double integratedLocation(double q) {
        return this.compression * (MergingDigest.asinApproximation(2.0 * q - 1.0) + 1.5707963267948966) / Math.PI;
    }

    private double integratedQ(double k) {
        return (Math.sin(Math.min(k, this.compression) * Math.PI / this.compression - 1.5707963267948966) + 1.0) / 2.0;
    }

    static double asinApproximation(double x) {
        if (usePieceWiseApproximation) {
            if (x < 0.0) {
                return -MergingDigest.asinApproximation(-x);
            }
            double c0High = 0.1;
            double c1High = 0.55;
            double c2Low = 0.5;
            double c2High = 0.8;
            double c3Low = 0.75;
            double c3High = 0.9;
            double c4Low = 0.87;
            if (x > c3High) {
                return Math.asin(x);
            }
            double[] m0 = new double[]{0.2955302411, 1.2221903614, 0.1488583743, 0.2422015816, -0.3688700895, 0.0733398445};
            double[] m1 = new double[]{-0.043099192, 0.959403575, -0.0362312299, 0.1204623351, 0.045702962, -0.0026025285};
            double[] m2 = new double[]{-0.034873933724, 1.054796752703, -0.194127063385, 0.283963735636, 0.023800124916, -8.72727381E-4};
            double[] m3 = new double[]{-0.37588391875, 2.61991859025, -2.48835406886, 1.48605387425, 0.00857627492, -1.5802871E-4};
            double[] vars = new double[]{1.0, x, x * x, x * x * x, 1.0 / (1.0 - x), 1.0 / (1.0 - x) / (1.0 - x)};
            double x0 = MergingDigest.bound((c0High - x) / c0High);
            double x1 = MergingDigest.bound((c1High - x) / (c1High - c2Low));
            double x2 = MergingDigest.bound((c2High - x) / (c2High - c3Low));
            double x3 = MergingDigest.bound((c3High - x) / (c3High - c4Low));
            double mix0 = x0;
            double mix1 = (1.0 - x0) * x1;
            double mix2 = (1.0 - x1) * x2;
            double mix3 = (1.0 - x2) * x3;
            double mix4 = 1.0 - x3;
            double r = 0.0;
            if (mix0 > 0.0) {
                r += mix0 * MergingDigest.eval(m0, vars);
            }
            if (mix1 > 0.0) {
                r += mix1 * MergingDigest.eval(m1, vars);
            }
            if (mix2 > 0.0) {
                r += mix2 * MergingDigest.eval(m2, vars);
            }
            if (mix3 > 0.0) {
                r += mix3 * MergingDigest.eval(m3, vars);
            }
            if (mix4 > 0.0) {
                r += mix4 * Math.asin(x);
            }
            return r;
        }
        return Math.asin(x);
    }

    private static double eval(double[] model, double[] vars) {
        double r = 0.0;
        for (int i = 0; i < model.length; ++i) {
            r += model[i] * vars[i];
        }
        return r;
    }

    private static double bound(double v) {
        if (v <= 0.0) {
            return 0.0;
        }
        if (v >= 1.0) {
            return 1.0;
        }
        return v;
    }

    @Override
    public void compress() {
        this.mergeNewValues();
    }

    @Override
    public long size() {
        return (long)(this.totalWeight + this.unmergedWeight);
    }

    @Override
    public double cdf(double x) {
        this.mergeNewValues();
        if (this.lastUsedCell == 0) {
            return Double.NaN;
        }
        if (this.lastUsedCell == 1) {
            double width = this.max - this.min;
            if (x < this.min) {
                return 0.0;
            }
            if (x > this.max) {
                return 1.0;
            }
            if (x - this.min <= width) {
                return 0.5;
            }
            return (x - this.min) / (this.max - this.min);
        }
        int n = this.lastUsedCell;
        if (x <= this.min) {
            return 0.0;
        }
        if (x >= this.max) {
            return 1.0;
        }
        if (x <= this.mean[0]) {
            if (this.mean[0] - this.min > 0.0) {
                return (x - this.min) / (this.mean[0] - this.min) * this.weight[0] / this.totalWeight / 2.0;
            }
            return 0.0;
        }
        assert (x > this.mean[0]);
        if (x >= this.mean[n - 1]) {
            if (this.max - this.mean[n - 1] > 0.0) {
                return 1.0 - (this.max - x) / (this.max - this.mean[n - 1]) * this.weight[n - 1] / this.totalWeight / 2.0;
            }
            return 1.0;
        }
        assert (x < this.mean[n - 1]);
        double weightSoFar = this.weight[0] / 2.0;
        for (int it = 0; it < n; ++it) {
            if (this.mean[it] == x) {
                double w0 = weightSoFar;
                while (it < n && this.mean[it + 1] == x) {
                    weightSoFar += this.weight[it] + this.weight[it + 1];
                    ++it;
                }
                return (w0 + weightSoFar) / 2.0 / this.totalWeight;
            }
            if (this.mean[it] <= x && this.mean[it + 1] > x) {
                if (this.mean[it + 1] - this.mean[it] > 0.0) {
                    double dw = (this.weight[it] + this.weight[it + 1]) / 2.0;
                    return (weightSoFar + dw * (x - this.mean[it]) / (this.mean[it + 1] - this.mean[it])) / this.totalWeight;
                }
                double dw = (this.weight[it] + this.weight[it + 1]) / 2.0;
                return weightSoFar + dw / this.totalWeight;
            }
            weightSoFar += (this.weight[it] + this.weight[it + 1]) / 2.0;
        }
        throw new IllegalStateException("Can't happen ... loop fell through");
    }

    @Override
    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        this.mergeNewValues();
        if (this.lastUsedCell == 0 && this.weight[this.lastUsedCell] == 0.0) {
            return Double.NaN;
        }
        if (this.lastUsedCell == 0) {
            return this.mean[0];
        }
        int n = this.lastUsedCell;
        double index = q * this.totalWeight;
        if (index < this.weight[0] / 2.0) {
            assert (this.weight[0] > 0.0);
            return this.min + 2.0 * index / this.weight[0] * (this.mean[0] - this.min);
        }
        double weightSoFar = this.weight[0] / 2.0;
        for (int i = 0; i < n - 1; ++i) {
            double dw = (this.weight[i] + this.weight[i + 1]) / 2.0;
            if (weightSoFar + dw > index) {
                double z1 = index - weightSoFar;
                double z2 = weightSoFar + dw - index;
                return MergingDigest.weightedAverage(this.mean[i], z2, this.mean[i + 1], z1);
            }
            weightSoFar += dw;
        }
        assert (index <= this.totalWeight);
        assert (index >= this.totalWeight - this.weight[n - 1] / 2.0);
        double z1 = index - this.totalWeight - this.weight[n - 1] / 2.0;
        double z2 = this.weight[n - 1] / 2.0 - z1;
        return MergingDigest.weightedAverage(this.mean[n - 1], z1, this.max, z2);
    }

    @Override
    public int centroidCount() {
        return this.lastUsedCell;
    }

    @Override
    public Collection<Centroid> centroids() {
        this.compress();
        return new AbstractCollection<Centroid>(){

            @Override
            public Iterator<Centroid> iterator() {
                return new Iterator<Centroid>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < MergingDigest.this.lastUsedCell;
                    }

                    @Override
                    public Centroid next() {
                        Centroid rc = new Centroid(MergingDigest.this.mean[this.i], (int)MergingDigest.this.weight[this.i], MergingDigest.this.data != null ? MergingDigest.this.data.get(this.i) : null);
                        ++this.i;
                        return rc;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Default operation");
                    }
                };
            }

            @Override
            public int size() {
                return MergingDigest.this.lastUsedCell;
            }
        };
    }

    @Override
    public double compression() {
        return this.compression;
    }

    @Override
    public int byteSize() {
        this.compress();
        return this.lastUsedCell * 16 + 32;
    }

    @Override
    public int smallByteSize() {
        this.compress();
        return this.lastUsedCell * 8 + 30;
    }

    @Override
    public void asBytes(ByteBuffer buf) {
        this.compress();
        buf.putInt(Encoding.VERBOSE_ENCODING.code);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putDouble(this.compression);
        buf.putInt(this.lastUsedCell);
        for (int i = 0; i < this.lastUsedCell; ++i) {
            buf.putDouble(this.weight[i]);
            buf.putDouble(this.mean[i]);
        }
    }

    @Override
    public void asSmallBytes(ByteBuffer buf) {
        this.compress();
        buf.putInt(Encoding.SMALL_ENCODING.code);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putFloat((float)this.compression);
        buf.putShort((short)this.mean.length);
        buf.putShort((short)this.tempMean.length);
        buf.putShort((short)this.lastUsedCell);
        for (int i = 0; i < this.lastUsedCell; ++i) {
            buf.putFloat((float)this.weight[i]);
            buf.putFloat((float)this.mean[i]);
        }
    }

    public static MergingDigest fromBytes(ByteBuffer buf) {
        int encoding = buf.getInt();
        if (encoding == Encoding.VERBOSE_ENCODING.code) {
            double min = buf.getDouble();
            double max = buf.getDouble();
            double compression = buf.getDouble();
            int n = buf.getInt();
            MergingDigest r = new MergingDigest(compression);
            r.setMinMax(min, max);
            r.lastUsedCell = n;
            for (int i = 0; i < n; ++i) {
                r.weight[i] = buf.getDouble();
                r.mean[i] = buf.getDouble();
                r.totalWeight += r.weight[i];
            }
            return r;
        }
        if (encoding == Encoding.SMALL_ENCODING.code) {
            double min = buf.getDouble();
            double max = buf.getDouble();
            double compression = buf.getFloat();
            short n = buf.getShort();
            short bufferSize = buf.getShort();
            MergingDigest r = new MergingDigest(compression, bufferSize, n);
            r.setMinMax(min, max);
            r.lastUsedCell = buf.getShort();
            for (int i = 0; i < r.lastUsedCell; ++i) {
                r.weight[i] = buf.getFloat();
                r.mean[i] = buf.getFloat();
                r.totalWeight += r.weight[i];
            }
            return r;
        }
        throw new IllegalStateException("Invalid format for serialized histogram");
    }

    public static enum Encoding {
        VERBOSE_ENCODING(1),
        SMALL_ENCODING(2);

        private final int code;

        private Encoding(int code) {
            this.code = code;
        }
    }
}

