/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LatLonDocValuesBoxQuery;
import org.apache.lucene.document.LatLonDocValuesDistanceQuery;
import org.apache.lucene.document.LatLonDocValuesPointInPolygonQuery;
import org.apache.lucene.document.LatLonPointSortField;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

public class LatLonDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public LatLonDocValuesField(String name, double latitude, double longitude) {
        super(name, TYPE);
        this.setLocationValue(latitude, longitude);
    }

    public void setLocationValue(double latitude, double longitude) {
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude(latitude);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude(longitude);
        this.fieldsData = (long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + fieldInfo.getDocValuesType() + " but this type has docValuesType=" + TYPE.docValuesType() + ", is the field really a LatLonDocValuesField?");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(GeoEncodingUtils.decodeLatitude((int)(currentValue >> 32)));
        result.append(',');
        result.append(GeoEncodingUtils.decodeLongitude((int)(currentValue & 0xFFFFFFFFFFFFFFFFL)));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field, double latitude, double longitude) {
        return new LatLonPointSortField(field, latitude, longitude);
    }

    public static Query newSlowBoxQuery(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (minLatitude == 90.0) {
            return new MatchNoDocsQuery("LatLonDocValuesField.newBoxQuery with minLatitude=90.0");
        }
        if (minLongitude == 180.0) {
            if (maxLongitude == 180.0) {
                return new MatchNoDocsQuery("LatLonDocValuesField.newBoxQuery with minLongitude=maxLongitude=180.0");
            }
            if (maxLongitude < minLongitude) {
                minLongitude = -180.0;
            }
        }
        return new LatLonDocValuesBoxQuery(field, minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static Query newSlowDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        return new LatLonDocValuesDistanceQuery(field, latitude, longitude, radiusMeters);
    }

    public static Query newSlowPolygonQuery(String field, Polygon ... polygons) {
        return new LatLonDocValuesPointInPolygonQuery(field, polygons);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

