/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Line2D;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class LatLonShapeLineQuery
extends ShapeQuery {
    final Line[] lines;
    private final Component2D line2D;

    public LatLonShapeLineQuery(String field, ShapeField.QueryRelation queryRelation, Line ... lines) {
        super(field, queryRelation);
        if (queryRelation == ShapeField.QueryRelation.WITHIN) {
            throw new IllegalArgumentException("LatLonShapeLineQuery does not support " + ShapeField.QueryRelation.WITHIN + " queries");
        }
        if (lines == null) {
            throw new IllegalArgumentException("lines must not be null");
        }
        if (lines.length == 0) {
            throw new IllegalArgumentException("lines must not be empty");
        }
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) {
                throw new IllegalArgumentException("line[" + i + "] must not be null");
            }
            if (!(lines[i].minLon > lines[i].maxLon)) continue;
            throw new IllegalArgumentException("LatLonShapeLineQuery does not currently support querying across dateline.");
        }
        this.lines = (Line[])lines.clone();
        this.line2D = Line2D.create(lines);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(minTriangle, minYOffset));
        double minLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(minTriangle, minXOffset));
        double maxLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(maxTriangle, maxYOffset));
        double maxLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(maxTriangle, maxXOffset));
        return this.line2D.relate(minLon, maxLon, minLat, maxLat);
    }

    @Override
    protected boolean queryMatches(byte[] t, ShapeField.DecodedTriangle scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
        double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
        double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
        double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
        double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
        double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
        switch (queryRelation) {
            case INTERSECTS: {
                return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) != PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            case WITHIN: {
                return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_INSIDE_QUERY;
            }
            case DISJOINT: {
                return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        throw new IllegalArgumentException("Unsupported query type :[" + queryRelation + "]");
    }

    @Override
    protected Component2D.WithinRelation queryWithin(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
        double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
        double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
        double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
        double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
        double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
        return this.line2D.withinTriangle(alon, alat, scratchTriangle.ab, blon, blat, scratchTriangle.bc, clon, clat, scratchTriangle.ca);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("Line(").append(this.lines[0].toGeoJSON()).append(')');
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.lines, ((LatLonShapeLineQuery)o).lines);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.lines);
        return hash;
    }
}

