/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;

final class SegmentCoreReaders {
    private final AtomicInteger ref = new AtomicInteger(1);
    final FieldsProducer fields;
    final NormsProducer normsProducer;
    final StoredFieldsReader fieldsReaderOrig;
    final TermVectorsReader termVectorsReaderOrig;
    final PointsReader pointsReader;
    final Directory cfsReader;
    final String segment;
    final FieldInfos coreFieldInfos;
    final CloseableThreadLocal<StoredFieldsReader> fieldsReaderLocal = new CloseableThreadLocal<StoredFieldsReader>(){

        @Override
        protected StoredFieldsReader initialValue() {
            return SegmentCoreReaders.this.fieldsReaderOrig.clone();
        }
    };
    final CloseableThreadLocal<TermVectorsReader> termVectorsLocal = new CloseableThreadLocal<TermVectorsReader>(){

        @Override
        protected TermVectorsReader initialValue() {
            return SegmentCoreReaders.this.termVectorsReaderOrig == null ? null : SegmentCoreReaders.this.termVectorsReaderOrig.clone();
        }
    };
    private final Set<IndexReader.ClosedListener> coreClosedListeners = Collections.synchronizedSet(new LinkedHashSet());
    private final IndexReader.CacheHelper cacheHelper = new IndexReader.CacheHelper(){
        private final IndexReader.CacheKey cacheKey = new IndexReader.CacheKey();

        @Override
        public IndexReader.CacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public void addClosedListener(IndexReader.ClosedListener listener) {
            SegmentCoreReaders.this.coreClosedListeners.add(listener);
        }
    };

    SegmentCoreReaders(Directory dir, SegmentCommitInfo si, boolean openedFromWriter, IOContext context, Map<String, String> readerAttributes) throws IOException {
        Codec codec = si.info.getCodec();
        boolean success = false;
        try {
            Directory cfsDir;
            if (si.info.getUseCompoundFile()) {
                cfsDir = this.cfsReader = codec.compoundFormat().getCompoundReader(dir, si.info, context);
            } else {
                this.cfsReader = null;
                cfsDir = dir;
            }
            this.segment = si.info.name;
            this.coreFieldInfos = codec.fieldInfosFormat().read(cfsDir, si.info, "", context);
            SegmentReadState segmentReadState = new SegmentReadState(cfsDir, si.info, this.coreFieldInfos, openedFromWriter, context, readerAttributes);
            PostingsFormat format = codec.postingsFormat();
            this.fields = format.fieldsProducer(segmentReadState);
            assert (this.fields != null);
            if (this.coreFieldInfos.hasNorms()) {
                this.normsProducer = codec.normsFormat().normsProducer(segmentReadState);
                assert (this.normsProducer != null);
            } else {
                this.normsProducer = null;
            }
            this.fieldsReaderOrig = si.info.getCodec().storedFieldsFormat().fieldsReader(cfsDir, si.info, this.coreFieldInfos, context);
            this.termVectorsReaderOrig = this.coreFieldInfos.hasVectors() ? si.info.getCodec().termVectorsFormat().vectorsReader(cfsDir, si.info, this.coreFieldInfos, context) : null;
            this.pointsReader = this.coreFieldInfos.hasPointValues() ? codec.pointsFormat().fieldsReader(segmentReadState) : null;
            success = true;
        }
        catch (EOFException | FileNotFoundException e) {
            throw new CorruptIndexException("Problem reading index from " + dir, dir.toString(), (Throwable)e);
        }
        catch (NoSuchFileException e) {
            throw new CorruptIndexException("Problem reading index.", e.getFile(), (Throwable)e);
        }
        finally {
            if (!success) {
                this.decRef();
            }
        }
    }

    int getRefCount() {
        return this.ref.get();
    }

    void incRef() {
        int count;
        while ((count = this.ref.get()) > 0) {
            if (!this.ref.compareAndSet(count, count + 1)) continue;
            return;
        }
        throw new AlreadyClosedException("SegmentCoreReaders is already closed");
    }

    void decRef() throws IOException {
        if (this.ref.decrementAndGet() == 0) {
            try (Closeable finalizer = this::notifyCoreClosedListeners;){
                IOUtils.close(this.termVectorsLocal, this.fieldsReaderLocal, this.fields, this.termVectorsReaderOrig, this.fieldsReaderOrig, this.cfsReader, this.normsProducer, this.pointsReader);
            }
        }
    }

    IndexReader.CacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCoreClosedListeners() throws IOException {
        Set<IndexReader.ClosedListener> set = this.coreClosedListeners;
        synchronized (set) {
            IOUtils.applyToAll(this.coreClosedListeners, l -> l.onClose(this.cacheHelper.getKey()));
        }
    }

    public String toString() {
        return "SegmentCoreReader(" + this.segment + ")";
    }
}

