/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.Version;

final class SegmentMerger {
    private final Directory directory;
    private final Codec codec;
    private final IOContext context;
    final MergeState mergeState;
    private final FieldInfos.Builder fieldInfosBuilder;

    SegmentMerger(List<CodecReader> readers, SegmentInfo segmentInfo, InfoStream infoStream, Directory dir, FieldInfos.FieldNumbers fieldNumbers, IOContext context) throws IOException {
        if (context.context != IOContext.Context.MERGE) {
            throw new IllegalArgumentException("IOContext.context should be MERGE; got: " + context.context);
        }
        this.mergeState = new MergeState(readers, segmentInfo, infoStream);
        this.directory = dir;
        this.codec = segmentInfo.getCodec();
        this.context = context;
        this.fieldInfosBuilder = new FieldInfos.Builder(fieldNumbers);
        Version minVersion = Version.LATEST;
        for (CodecReader reader : readers) {
            Version leafMinVersion = reader.getMetaData().getMinVersion();
            if (leafMinVersion == null) {
                minVersion = null;
                break;
            }
            if (!minVersion.onOrAfter(leafMinVersion)) continue;
            minVersion = leafMinVersion;
        }
        assert (segmentInfo.minVersion == null) : "The min version should be set by SegmentMerger for merged segments";
        segmentInfo.minVersion = minVersion;
        if (this.mergeState.infoStream.isEnabled("SM") && segmentInfo.getIndexSort() != null) {
            this.mergeState.infoStream.message("SM", "index sort during merge: " + segmentInfo.getIndexSort());
        }
    }

    boolean shouldMerge() {
        return this.mergeState.segmentInfo.maxDoc() > 0;
    }

    MergeState merge() throws IOException {
        if (!this.shouldMerge()) {
            throw new IllegalStateException("Merge would result in 0 document segment");
        }
        this.mergeFieldInfos();
        long t0 = 0L;
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        int numMerged = this.mergeFields();
        if (this.mergeState.infoStream.isEnabled("SM")) {
            long t1 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge stored fields [" + numMerged + " docs]");
        }
        assert (numMerged == this.mergeState.segmentInfo.maxDoc()) : "numMerged=" + numMerged + " vs mergeState.segmentInfo.maxDoc()=" + this.mergeState.segmentInfo.maxDoc();
        SegmentWriteState segmentWriteState = new SegmentWriteState(this.mergeState.infoStream, this.directory, this.mergeState.segmentInfo, this.mergeState.mergeFieldInfos, null, this.context);
        SegmentReadState segmentReadState = new SegmentReadState(this.directory, this.mergeState.segmentInfo, this.mergeState.mergeFieldInfos, true, IOContext.READ, segmentWriteState.segmentSuffix, Collections.emptyMap());
        if (this.mergeState.mergeFieldInfos.hasNorms()) {
            if (this.mergeState.infoStream.isEnabled("SM")) {
                t0 = System.nanoTime();
            }
            this.mergeNorms(segmentWriteState);
            if (this.mergeState.infoStream.isEnabled("SM")) {
                long t1 = System.nanoTime();
                this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge norms [" + numMerged + " docs]");
            }
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        try (NormsProducer norms = this.mergeState.mergeFieldInfos.hasNorms() ? this.codec.normsFormat().normsProducer(segmentReadState) : null;){
            NormsProducer normsMergeInstance = null;
            if (norms != null) {
                normsMergeInstance = norms.getMergeInstance();
            }
            this.mergeTerms(segmentWriteState, normsMergeInstance);
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            long t1 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge postings [" + numMerged + " docs]");
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        if (this.mergeState.mergeFieldInfos.hasDocValues()) {
            this.mergeDocValues(segmentWriteState);
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            long t1 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge doc values [" + numMerged + " docs]");
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        if (this.mergeState.mergeFieldInfos.hasPointValues()) {
            this.mergePoints(segmentWriteState);
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            long t1 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge points [" + numMerged + " docs]");
        }
        if (this.mergeState.mergeFieldInfos.hasVectors()) {
            if (this.mergeState.infoStream.isEnabled("SM")) {
                t0 = System.nanoTime();
            }
            numMerged = this.mergeVectors();
            if (this.mergeState.infoStream.isEnabled("SM")) {
                long t1 = System.nanoTime();
                this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to merge vectors [" + numMerged + " docs]");
            }
            assert (numMerged == this.mergeState.segmentInfo.maxDoc());
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        this.codec.fieldInfosFormat().write(this.directory, this.mergeState.segmentInfo, "", this.mergeState.mergeFieldInfos, this.context);
        if (this.mergeState.infoStream.isEnabled("SM")) {
            long t1 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (t1 - t0) / 1000000L + " msec to write field infos [" + numMerged + " docs]");
        }
        return this.mergeState;
    }

    private void mergeDocValues(SegmentWriteState segmentWriteState) throws IOException {
        try (DocValuesConsumer consumer = this.codec.docValuesFormat().fieldsConsumer(segmentWriteState);){
            consumer.merge(this.mergeState);
        }
    }

    private void mergePoints(SegmentWriteState segmentWriteState) throws IOException {
        try (PointsWriter writer = this.codec.pointsFormat().fieldsWriter(segmentWriteState);){
            writer.merge(this.mergeState);
        }
    }

    private void mergeNorms(SegmentWriteState segmentWriteState) throws IOException {
        try (NormsConsumer consumer = this.codec.normsFormat().normsConsumer(segmentWriteState);){
            consumer.merge(this.mergeState);
        }
    }

    public void mergeFieldInfos() throws IOException {
        for (FieldInfos readerFieldInfos : this.mergeState.fieldInfos) {
            for (FieldInfo fi : readerFieldInfos) {
                this.fieldInfosBuilder.add(fi);
            }
        }
        this.mergeState.mergeFieldInfos = this.fieldInfosBuilder.finish();
    }

    private int mergeFields() throws IOException {
        try (StoredFieldsWriter fieldsWriter = this.codec.storedFieldsFormat().fieldsWriter(this.directory, this.mergeState.segmentInfo, this.context);){
            int n = fieldsWriter.merge(this.mergeState);
            return n;
        }
    }

    private int mergeVectors() throws IOException {
        try (TermVectorsWriter termVectorsWriter = this.codec.termVectorsFormat().vectorsWriter(this.directory, this.mergeState.segmentInfo, this.context);){
            int n = termVectorsWriter.merge(this.mergeState);
            return n;
        }
    }

    private void mergeTerms(SegmentWriteState segmentWriteState, NormsProducer norms) throws IOException {
        try (FieldsConsumer consumer = this.codec.postingsFormat().fieldsConsumer(segmentWriteState);){
            consumer.merge(this.mergeState, norms);
        }
    }
}

