/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingLeafReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.packed.PackedLongValues;

class SortedDocValuesWriter
extends DocValuesWriter {
    final BytesRefHash hash;
    private PackedLongValues.Builder pending;
    private DocsWithFieldSet docsWithField;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int lastDocID = -1;
    private PackedLongValues finalOrds;
    private int[] finalSortedValues;
    private int[] finalOrdMap;

    public SortedDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.hash = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(iwBytesUsed)), 16, new BytesRefHash.DirectBytesStartArray(16, iwBytesUsed));
        this.pending = PackedLongValues.deltaPackedBuilder(0.0f);
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, BytesRef value) {
        if (docID <= this.lastDocID) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        if (value == null) {
            throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (value.length > 32766) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= 32766");
        }
        this.addOneValue(value);
        this.docsWithField.add(docID);
        this.lastDocID = docID;
    }

    @Override
    public void finish(int maxDoc) {
        this.updateBytesUsed();
    }

    private void addOneValue(BytesRef value) {
        int termID = this.hash.add(value);
        if (termID < 0) {
            termID = -termID - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        this.pending.add(termID);
        this.updateBytesUsed();
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    Sorter.DocComparator getDocComparator(int maxDoc, SortField sortField) throws IOException {
        assert (sortField.getType().equals((Object)SortField.Type.STRING));
        assert (this.finalSortedValues == null && this.finalOrdMap == null && this.finalOrds == null);
        int valueCount = this.hash.size();
        this.finalSortedValues = this.hash.sort();
        this.finalOrds = this.pending.build();
        this.finalOrdMap = new int[valueCount];
        for (int ord = 0; ord < valueCount; ++ord) {
            this.finalOrdMap[this.finalSortedValues[ord]] = ord;
        }
        BufferedSortedDocValues docValues = new BufferedSortedDocValues(this.hash, valueCount, this.finalOrds, this.finalSortedValues, this.finalOrdMap, this.docsWithField.iterator());
        return Sorter.getDocComparator(maxDoc, sortField, () -> docValues, () -> null);
    }

    private int[] sortDocValues(int maxDoc, Sorter.DocMap sortMap, SortedDocValues oldValues) throws IOException {
        int docID;
        int[] ords = new int[maxDoc];
        Arrays.fill(ords, -1);
        while ((docID = oldValues.nextDoc()) != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            ords[newDocID] = oldValues.ordValue();
        }
        return ords;
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        int[] ordMap;
        PackedLongValues ords;
        int[] sortedValues;
        final int valueCount = this.hash.size();
        if (this.finalOrds == null) {
            sortedValues = this.hash.sort();
            ords = this.pending.build();
            ordMap = new int[valueCount];
            for (int ord = 0; ord < valueCount; ++ord) {
                ordMap[sortedValues[ord]] = ord;
            }
        } else {
            sortedValues = this.finalSortedValues;
            ords = this.finalOrds;
            ordMap = this.finalOrdMap;
        }
        final int[] sorted = sortMap != null ? this.sortDocValues(state.segmentInfo.maxDoc(), sortMap, new BufferedSortedDocValues(this.hash, valueCount, ords, sortedValues, ordMap, this.docsWithField.iterator())) : null;
        dvConsumer.addSortedField(this.fieldInfo, new EmptyDocValuesProducer(){

            @Override
            public SortedDocValues getSorted(FieldInfo fieldInfoIn) {
                if (fieldInfoIn != SortedDocValuesWriter.this.fieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                BufferedSortedDocValues buf = new BufferedSortedDocValues(SortedDocValuesWriter.this.hash, valueCount, ords, sortedValues, ordMap, SortedDocValuesWriter.this.docsWithField.iterator());
                if (sorted == null) {
                    return buf;
                }
                return new SortingLeafReader.SortingSortedDocValues(buf, sorted);
            }
        });
    }

    @Override
    DocIdSetIterator getDocIdSet() {
        return this.docsWithField.iterator();
    }

    private static class BufferedSortedDocValues
    extends SortedDocValues {
        final BytesRefHash hash;
        final BytesRef scratch = new BytesRef();
        final int[] sortedValues;
        final int[] ordMap;
        final int valueCount;
        private int ord;
        final PackedLongValues.Iterator iter;
        final DocIdSetIterator docsWithField;

        public BufferedSortedDocValues(BytesRefHash hash, int valueCount, PackedLongValues docToOrd, int[] sortedValues, int[] ordMap, DocIdSetIterator docsWithField) {
            this.hash = hash;
            this.valueCount = valueCount;
            this.sortedValues = sortedValues;
            this.iter = docToOrd.iterator();
            this.ordMap = ordMap;
            this.docsWithField = docsWithField;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.ord = Math.toIntExact(this.iter.next());
                this.ord = this.ordMap[this.ord];
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            assert (ord >= 0 && ord < this.sortedValues.length);
            assert (this.sortedValues[ord] >= 0 && this.sortedValues[ord] < this.sortedValues.length);
            this.hash.get(this.sortedValues[ord], this.scratch);
            return this.scratch;
        }

        @Override
        public int getValueCount() {
            return this.valueCount;
        }
    }
}

