/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.concurrent.atomic.LongAccumulator;

final class MaxScoreAccumulator {
    static final int DEFAULT_INTERVAL = 1023;
    final LongAccumulator acc = new LongAccumulator(Long::max, Long.MIN_VALUE);
    long modInterval = 1023L;

    MaxScoreAccumulator() {
    }

    void accumulate(int docID, float score) {
        assert (docID >= 0 && score >= 0.0f);
        long encode = (long)Float.floatToIntBits(score) << 32 | (long)docID;
        this.acc.accumulate(encode);
    }

    DocAndScore get() {
        long value = this.acc.get();
        if (value == Long.MIN_VALUE) {
            return null;
        }
        float score = Float.intBitsToFloat((int)(value >> 32));
        int docID = (int)value;
        return new DocAndScore(docID, score);
    }

    static class DocAndScore
    implements Comparable<DocAndScore> {
        final int docID;
        final float score;

        DocAndScore(int docID, float score) {
            this.docID = docID;
            this.score = score;
        }

        @Override
        public int compareTo(DocAndScore o) {
            int cmp = Float.compare(this.score, o.score);
            if (cmp == 0) {
                return Integer.compare(this.docID, o.docID);
            }
            return cmp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocAndScore result = (DocAndScore)o;
            return this.docID == result.docID && Float.compare(result.score, this.score) == 0;
        }

        public String toString() {
            return "DocAndScore{docID=" + this.docID + ", score=" + this.score + "}";
        }
    }
}

