/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.xpack;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.client.license.LicenseStatus;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class XPackInfoResponse {
    public static final long BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS = Long.MAX_VALUE - TimeUnit.HOURS.toMillis(8760L);
    @Nullable
    private BuildInfo buildInfo;
    @Nullable
    private LicenseInfo licenseInfo;
    @Nullable
    private FeatureSetsInfo featureSetsInfo;
    private static final ConstructingObjectParser<XPackInfoResponse, Void> PARSER = new ConstructingObjectParser<XPackInfoResponse, Void>("xpack_info_response", true, (a, v) -> {
        BuildInfo buildInfo = (BuildInfo)a[0];
        LicenseInfo licenseInfo = (LicenseInfo)a[1];
        List featureSets = (List)a[2];
        FeatureSetsInfo featureSetsInfo = featureSets == null ? null : new FeatureSetsInfo(new HashSet<FeatureSetsInfo.FeatureSet>(featureSets));
        return new XPackInfoResponse(buildInfo, licenseInfo, featureSetsInfo);
    });

    public XPackInfoResponse() {
    }

    public XPackInfoResponse(@Nullable BuildInfo buildInfo, @Nullable LicenseInfo licenseInfo, @Nullable FeatureSetsInfo featureSetsInfo) {
        this.buildInfo = buildInfo;
        this.licenseInfo = licenseInfo;
        this.featureSetsInfo = featureSetsInfo;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    public FeatureSetsInfo getFeatureSetsInfo() {
        return this.featureSetsInfo;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this == other) {
            return true;
        }
        XPackInfoResponse rhs = (XPackInfoResponse)other;
        return Objects.equals(this.buildInfo, rhs.buildInfo) && Objects.equals(this.licenseInfo, rhs.licenseInfo) && Objects.equals(this.featureSetsInfo, rhs.featureSetsInfo);
    }

    public int hashCode() {
        return Objects.hash(this.buildInfo, this.licenseInfo, this.featureSetsInfo);
    }

    public String toString() {
        return "XPackInfoResponse{buildInfo=" + this.buildInfo + ", licenseInfo=" + this.licenseInfo + ", featureSetsInfo=" + this.featureSetsInfo + "}";
    }

    public static XPackInfoResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), BuildInfo.PARSER, new ParseField("build", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, v) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            return LicenseInfo.PARSER.parse(p, (Void)v);
        }, new ParseField("license", new String[0]), ObjectParser.ValueType.OBJECT_OR_NULL);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, name) -> FeatureSetsInfo.FeatureSet.PARSER.parse(p, name), new ParseField("features", new String[0]));
    }

    public static class FeatureSetsInfo {
        private final Map<String, FeatureSet> featureSets;

        public FeatureSetsInfo(Set<FeatureSet> featureSets) {
            HashMap<String, FeatureSet> map = new HashMap<String, FeatureSet>(featureSets.size());
            for (FeatureSet featureSet : featureSets) {
                map.put(featureSet.name, featureSet);
            }
            this.featureSets = Collections.unmodifiableMap(map);
        }

        public Map<String, FeatureSet> getFeatureSets() {
            return this.featureSets;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            FeatureSetsInfo rhs = (FeatureSetsInfo)other;
            return Objects.equals(this.featureSets, rhs.featureSets);
        }

        public int hashCode() {
            return Objects.hash(this.featureSets);
        }

        public String toString() {
            return "FeatureSetsInfo{featureSets=" + this.featureSets + "}";
        }

        public static class FeatureSet {
            private final String name;
            @Nullable
            private final String description;
            private final boolean available;
            private final boolean enabled;
            @Nullable
            private final Map<String, Object> nativeCodeInfo;
            private static final ConstructingObjectParser<FeatureSet, String> PARSER = new ConstructingObjectParser<FeatureSet, String>("feature_set", true, (a, name) -> {
                String description = (String)a[0];
                boolean available = (Boolean)a[1];
                boolean enabled = (Boolean)a[2];
                Map nativeCodeInfo = (Map)a[3];
                return new FeatureSet((String)name, description, available, enabled, nativeCodeInfo);
            });

            public FeatureSet(String name, @Nullable String description, boolean available, boolean enabled, @Nullable Map<String, Object> nativeCodeInfo) {
                this.name = name;
                this.description = description;
                this.available = available;
                this.enabled = enabled;
                this.nativeCodeInfo = nativeCodeInfo;
            }

            public String name() {
                return this.name;
            }

            public boolean available() {
                return this.available;
            }

            public boolean enabled() {
                return this.enabled;
            }

            @Deprecated
            @Nullable
            public Map<String, Object> nativeCodeInfo() {
                return this.nativeCodeInfo;
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                if (this == other) {
                    return true;
                }
                FeatureSet rhs = (FeatureSet)other;
                return Objects.equals(this.name, rhs.name) && Objects.equals(this.description, rhs.description) && this.available == rhs.available && this.enabled == rhs.enabled && Objects.equals(this.nativeCodeInfo, rhs.nativeCodeInfo);
            }

            public int hashCode() {
                return Objects.hash(this.name, this.description, this.available, this.enabled, this.nativeCodeInfo);
            }

            public String toString() {
                return "FeatureSet{name='" + this.name + "', description='" + this.description + "', available=" + this.available + ", enabled=" + this.enabled + ", nativeCodeInfo=" + this.nativeCodeInfo + "}";
            }

            static {
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("description", new String[0]));
                PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("available", new String[0]));
                PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("enabled", new String[0]));
                PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, name) -> p.map(), new ParseField("native_code_info", new String[0]));
            }
        }
    }

    public static class BuildInfo {
        private final String hash;
        private final String timestamp;
        private static final ConstructingObjectParser<BuildInfo, Void> PARSER = new ConstructingObjectParser<BuildInfo, Void>("build_info", true, (a, v) -> new BuildInfo((String)a[0], (String)a[1]));

        public BuildInfo(String hash, String timestamp) {
            this.hash = hash;
            this.timestamp = timestamp;
        }

        public String getHash() {
            return this.hash;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            BuildInfo rhs = (BuildInfo)other;
            return Objects.equals(this.hash, rhs.hash) && Objects.equals(this.timestamp, rhs.timestamp);
        }

        public int hashCode() {
            return Objects.hash(this.hash, this.timestamp);
        }

        public String toString() {
            return "BuildInfo{hash='" + this.hash + "', timestamp='" + this.timestamp + "'}";
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("hash", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("date", new String[0]));
        }
    }

    public static class LicenseInfo {
        private final String uid;
        private final String type;
        private final String mode;
        private final LicenseStatus status;
        private final long expiryDate;
        private static final ConstructingObjectParser<LicenseInfo, Void> PARSER = new ConstructingObjectParser<LicenseInfo, Void>("license_info", true, (a, v) -> {
            String uid = (String)a[0];
            String type = (String)a[1];
            String mode = (String)a[2];
            LicenseStatus status = LicenseStatus.fromString((String)a[3]);
            Long expiryDate = (Long)a[4];
            long primitiveExpiryDate = expiryDate == null ? BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS : expiryDate;
            return new LicenseInfo(uid, type, mode, status, primitiveExpiryDate);
        });

        public LicenseInfo(String uid, String type, String mode, LicenseStatus status, long expiryDate) {
            this.uid = uid;
            this.type = type;
            this.mode = mode;
            this.status = status;
            this.expiryDate = expiryDate;
        }

        public String getUid() {
            return this.uid;
        }

        public String getType() {
            return this.type;
        }

        public String getMode() {
            return this.mode;
        }

        public long getExpiryDate() {
            return this.expiryDate;
        }

        public LicenseStatus getStatus() {
            return this.status;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            LicenseInfo rhs = (LicenseInfo)other;
            return Objects.equals(this.uid, rhs.uid) && Objects.equals(this.type, rhs.type) && Objects.equals(this.mode, rhs.mode) && Objects.equals((Object)this.status, (Object)rhs.status) && this.expiryDate == rhs.expiryDate;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.uid, this.type, this.mode, this.status, this.expiryDate});
        }

        public String toString() {
            return "LicenseInfo{uid='" + this.uid + "', type='" + this.type + "', mode='" + this.mode + "', status=" + this.status + ", expiryDate=" + this.expiryDate + "}";
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("uid", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("mode", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("status", new String[0]));
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiry_date_in_millis", new String[0]));
        }
    }
}

