/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.lucene.util.mutable.MutableValueInt;

public final class CopyOnWriteHashMap<K, V>
extends AbstractMap<K, V> {
    private static final int TOTAL_HASH_BITS = 32;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int HASH_BITS = 6;
    private static final int HASH_MASK = 63;
    private final InnerNode<K, V> root;
    private final int size;

    public static <K, V> CopyOnWriteHashMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        if (map instanceof CopyOnWriteHashMap) {
            CopyOnWriteHashMap cowMap = (CopyOnWriteHashMap)map;
            return cowMap;
        }
        return new CopyOnWriteHashMap<K, V>().copyAndPutAll(map);
    }

    private static <T> T[] removeArrayElement(T[] array, int index) {
        Object result = Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, result, index, array.length - index - 1);
        }
        return (Object[])result;
    }

    public static <T> T[] appendElement(T[] array, T element) {
        T[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static <T> T[] insertElement(T[] array, T element, int index) {
        T[] result = Arrays.copyOf(array, array.length + 1);
        System.arraycopy(array, 0, result, 0, index);
        result[index] = element;
        if (index < array.length) {
            System.arraycopy(array, index, result, index + 1, array.length - index);
        }
        return result;
    }

    public CopyOnWriteHashMap() {
        this(new InnerNode(), 0);
    }

    private CopyOnWriteHashMap(InnerNode<K, V> root, int size) {
        this.root = root;
        this.size = size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("null keys are not supported");
        }
        int hash = key.hashCode();
        return this.root.get(key, hash);
    }

    @Override
    public int size() {
        assert (this.size != 0 || this.root.isEmpty());
        return this.size;
    }

    public CopyOnWriteHashMap<K, V> copyAndPut(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("null keys are not supported");
        }
        if (value == null) {
            throw new IllegalArgumentException("null values are not supported");
        }
        int hash = key.hashCode();
        MutableValueInt newValue = new MutableValueInt();
        Node newRoot = this.root.put((Object)key, hash, 32, (Object)value, newValue);
        int newSize = this.size + newValue.value;
        return new CopyOnWriteHashMap<K, V>(newRoot, newSize);
    }

    public CopyOnWriteHashMap<K, V> copyAndPutAll(Map<? extends K, ? extends V> other) {
        return this.copyAndPutAll(other.entrySet());
    }

    public <K1 extends K, V1 extends V> CopyOnWriteHashMap<K, V> copyAndPutAll(Iterable<Map.Entry<K1, V1>> entries) {
        CopyOnWriteHashMap<K1, V1> result = this;
        for (Map.Entry<K1, V1> entry : entries) {
            result = result.copyAndPut(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public <K1 extends K, V1 extends V> CopyOnWriteHashMap<K, V> copyAndPutAll(Stream<Map.Entry<K1, V1>> entries) {
        return this.copyAndPutAll(entries::iterator);
    }

    public CopyOnWriteHashMap<K, V> copyAndRemove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("null keys are not supported");
        }
        int hash = key.hashCode();
        Node newRoot = this.root.remove(key, hash);
        if (this.root == newRoot) {
            return this;
        }
        return new CopyOnWriteHashMap<K, V>(newRoot, this.size - 1);
    }

    public CopyOnWriteHashMap<K, V> copyAndRemoveAll(Collection<?> keys) {
        CopyOnWriteHashMap<K, V> result = this;
        for (Object key : keys) {
            result = result.copyAndRemove(key);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator(CopyOnWriteHashMap.this.root);
            }

            @Override
            public boolean contains(Object o) {
                if (o == null || !(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return entry.getValue().equals(CopyOnWriteHashMap.this.get(entry.getKey()));
            }

            @Override
            public int size() {
                return CopyOnWriteHashMap.this.size();
            }
        };
    }

    private static class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Deque<Map.Entry<K, V>> entries = new ArrayDeque<Map.Entry<K, V>>();
        private final Deque<Node<K, V>> nodes = new ArrayDeque<Node<K, V>>();

        EntryIterator(Node<K, V> node) {
            node.visit(this.entries, this.nodes);
        }

        @Override
        public boolean hasNext() {
            return !this.entries.isEmpty() || !this.nodes.isEmpty();
        }

        @Override
        public Map.Entry<K, V> next() {
            while (this.entries.isEmpty()) {
                if (this.nodes.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Node<K, V> nextNode = this.nodes.pop();
                nextNode.visit(this.entries, this.nodes);
            }
            return this.entries.pop();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class InnerNode<K, V>
    extends Node<K, V> {
        private final long mask;
        private final K[] keys;
        final Object[] subNodes;

        InnerNode(long mask, K[] keys, Object[] subNodes) {
            this.mask = mask;
            this.keys = keys;
            this.subNodes = subNodes;
            assert (this.consistent());
        }

        private boolean consistent() {
            assert (Long.bitCount(this.mask) == this.keys.length);
            assert (Long.bitCount(this.mask) == this.subNodes.length);
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.subNodes[i] instanceof Node ? !$assertionsDisabled && this.keys[i] != null : !$assertionsDisabled && this.keys[i] == null) {
                    throw new AssertionError();
                }
            }
            return true;
        }

        @Override
        boolean isEmpty() {
            return this.mask == 0L;
        }

        InnerNode() {
            this(0L, EMPTY_ARRAY, EMPTY_ARRAY);
        }

        @Override
        void visit(Deque<Map.Entry<K, V>> entries, Deque<Node<K, V>> nodes) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object sub = this.subNodes[i];
                if (sub instanceof Node) {
                    Node subNode = (Node)sub;
                    assert (this.keys[i] == null);
                    nodes.add(subNode);
                    continue;
                }
                Object value = sub;
                entries.add(new AbstractMap.SimpleImmutableEntry<K, Object>(this.keys[i], value));
            }
        }

        private boolean exists(int hash6) {
            return (this.mask & 1L << hash6) != 0L;
        }

        private int slot(int hash6) {
            return Long.bitCount(this.mask & (1L << hash6) - 1L);
        }

        @Override
        V get(Object key, int hash) {
            int hash6 = hash & 0x3F;
            if (!this.exists(hash6)) {
                return null;
            }
            int slot = this.slot(hash6);
            Object sub = this.subNodes[slot];
            assert (sub != null);
            if (sub instanceof Node) {
                assert (this.keys[slot] == null);
                Node subNode = (Node)sub;
                return subNode.get(key, hash >>> 6);
            }
            if (this.keys[slot].equals(key)) {
                Object v = sub;
                return (V)v;
            }
            return null;
        }

        private Node<K, V> newSubNode(int hashBits) {
            if (hashBits <= 0) {
                return new Leaf();
            }
            return new InnerNode<K, V>();
        }

        private InnerNode<K, V> putExisting(K key, int hash, int hashBits, int slot, V value, MutableValueInt newValue) {
            K[] keys2 = Arrays.copyOf(this.keys, this.keys.length);
            Object[] subNodes2 = Arrays.copyOf(this.subNodes, this.subNodes.length);
            Object previousValue = subNodes2[slot];
            if (previousValue instanceof Node) {
                assert (this.keys[slot] == null);
                subNodes2[slot] = ((Node)previousValue).put(key, hash, hashBits, value, newValue);
            } else if (this.keys[slot].equals(key)) {
                subNodes2[slot] = value;
            } else {
                K previousKey = this.keys[slot];
                int previousHash = previousKey.hashCode() >>> 32 - hashBits;
                Node<K, Object> subNode = this.newSubNode(hashBits);
                subNode = subNode.put(previousKey, previousHash, hashBits, previousValue, newValue);
                subNode = subNode.put(key, hash, hashBits, value, newValue);
                keys2[slot] = null;
                subNodes2[slot] = subNode;
            }
            return new InnerNode<K, V>(this.mask, keys2, subNodes2);
        }

        private InnerNode<K, V> putNew(K key, int hash6, int slot, V value) {
            long mask2 = this.mask | 1L << hash6;
            K[] keys2 = CopyOnWriteHashMap.insertElement(this.keys, key, slot);
            Object[] subNodes2 = CopyOnWriteHashMap.insertElement(this.subNodes, value, slot);
            return new InnerNode<K, V>(mask2, keys2, subNodes2);
        }

        @Override
        InnerNode<K, V> put(K key, int hash, int hashBits, V value, MutableValueInt newValue) {
            int hash6 = hash & 0x3F;
            int slot = this.slot(hash6);
            if (this.exists(hash6)) {
                return this.putExisting(key, hash >>>= 6, hashBits -= 6, slot, value, newValue);
            }
            newValue.value = 1;
            return this.putNew(key, hash6, slot, value);
        }

        private InnerNode<K, V> removeSlot(int hash6, int slot) {
            long mask2 = this.mask & (1L << hash6 ^ 0xFFFFFFFFFFFFFFFFL);
            K[] keys2 = CopyOnWriteHashMap.removeArrayElement(this.keys, slot);
            Object[] subNodes2 = CopyOnWriteHashMap.removeArrayElement(this.subNodes, slot);
            return new InnerNode<K, V>(mask2, keys2, subNodes2);
        }

        @Override
        InnerNode<K, V> remove(Object key, int hash) {
            int hash6 = hash & 0x3F;
            if (!this.exists(hash6)) {
                return this;
            }
            int slot = this.slot(hash6);
            Object previousValue = this.subNodes[slot];
            if (previousValue instanceof Node) {
                Node subNode = (Node)previousValue;
                Node removed = subNode.remove(key, hash >>> 6);
                if (removed == subNode) {
                    return this;
                }
                if (removed.isEmpty()) {
                    return this.removeSlot(hash6, slot);
                }
                K[] keys2 = Arrays.copyOf(this.keys, this.keys.length);
                Object[] subNodes2 = Arrays.copyOf(this.subNodes, this.subNodes.length);
                subNodes2[slot] = removed;
                return new InnerNode<K, V>(this.mask, keys2, subNodes2);
            }
            if (this.keys[slot].equals(key)) {
                return this.removeSlot(hash6, slot);
            }
            return this;
        }
    }

    private static class Leaf<K, V>
    extends Node<K, V> {
        private final K[] keys;
        private final V[] values;

        Leaf(K[] keys, V[] values) {
            this.keys = keys;
            this.values = values;
        }

        Leaf() {
            this(EMPTY_ARRAY, EMPTY_ARRAY);
        }

        @Override
        boolean isEmpty() {
            return this.keys.length == 0;
        }

        @Override
        void visit(Deque<Map.Entry<K, V>> entries, Deque<Node<K, V>> nodes) {
            for (int i = 0; i < this.keys.length; ++i) {
                entries.add(new AbstractMap.SimpleImmutableEntry<K, V>(this.keys[i], this.values[i]));
            }
        }

        @Override
        V get(Object key, int hash) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!key.equals(this.keys[i])) continue;
                return this.values[i];
            }
            return null;
        }

        private static <T> T[] replace(T[] array, int index, T value) {
            T[] copy = Arrays.copyOf(array, array.length);
            copy[index] = value;
            return copy;
        }

        @Override
        Leaf<K, V> put(K key, int hash, int hashBits, V value, MutableValueInt newValue) {
            V[] values2;
            K[] keys2;
            assert (hashBits <= 0) : hashBits;
            int slot = -1;
            for (int i = 0; i < this.keys.length; ++i) {
                if (!key.equals(this.keys[i])) continue;
                slot = i;
                break;
            }
            if (slot < 0) {
                keys2 = CopyOnWriteHashMap.appendElement(this.keys, key);
                values2 = CopyOnWriteHashMap.appendElement(this.values, value);
                newValue.value = 1;
            } else {
                keys2 = Leaf.replace(this.keys, slot, key);
                values2 = Leaf.replace(this.values, slot, value);
            }
            return new Leaf<K, V>(keys2, values2);
        }

        @Override
        Leaf<K, V> remove(Object key, int hash) {
            int slot = -1;
            for (int i = 0; i < this.keys.length; ++i) {
                if (!key.equals(this.keys[i])) continue;
                slot = i;
                break;
            }
            if (slot < 0) {
                return this;
            }
            K[] keys2 = CopyOnWriteHashMap.removeArrayElement(this.keys, slot);
            V[] values2 = CopyOnWriteHashMap.removeArrayElement(this.values, slot);
            return new Leaf<K, V>(keys2, values2);
        }
    }

    private static abstract class Node<K, V> {
        private Node() {
        }

        abstract V get(Object var1, int var2);

        abstract Node<K, V> put(K var1, int var2, int var3, V var4, MutableValueInt var5);

        abstract Node<K, V> remove(Object var1, int var2);

        abstract void visit(Deque<Map.Entry<K, V>> var1, Deque<Node<K, V>> var2);

        abstract boolean isEmpty();
    }
}

