/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectObjectAssociativeContainer;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.ObjectObjectMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectObjectPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectObjectProcedure;
import java.util.Iterator;
import java.util.Map;

public final class ImmutableOpenMap<KType, VType>
implements Iterable<ObjectObjectCursor<KType, VType>> {
    private final ObjectObjectHashMap<KType, VType> map;
    private static final ImmutableOpenMap EMPTY = new ImmutableOpenMap(new ObjectObjectHashMap());

    private ImmutableOpenMap(ObjectObjectHashMap<KType, VType> map) {
        this.map = map;
    }

    public VType get(KType key) {
        return this.map.get(key);
    }

    public VType getOrDefault(KType key, VType defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    public boolean containsKey(KType key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<ObjectObjectCursor<KType, VType>> iterator() {
        return this.map.iterator();
    }

    public ObjectLookupContainer<KType> keys() {
        return this.map.keys();
    }

    public Iterator<KType> keysIt() {
        final Iterator iterator = this.map.keys().iterator();
        return new Iterator<KType>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public KType next() {
                return ((ObjectCursor)iterator.next()).value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ObjectContainer<VType> values() {
        return this.map.values();
    }

    public Iterator<VType> valuesIt() {
        final Iterator iterator = this.map.values().iterator();
        return new Iterator<VType>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public VType next() {
                return ((ObjectCursor)iterator.next()).value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableOpenMap that = (ImmutableOpenMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public static <KType, VType> ImmutableOpenMap<KType, VType> of() {
        return EMPTY;
    }

    public static <KType, VType> ImmutableOpenMap<KType, VType> copyOf(ObjectObjectMap<KType, VType> map) {
        Builder<KType, VType> builder = ImmutableOpenMap.builder();
        builder.putAll(map);
        return builder.build();
    }

    public static <KType, VType> Builder<KType, VType> builder() {
        return new Builder();
    }

    public static <KType, VType> Builder<KType, VType> builder(int size) {
        return new Builder(size);
    }

    public static <KType, VType> Builder<KType, VType> builder(ImmutableOpenMap<KType, VType> map) {
        return new Builder<KType, VType>(map);
    }

    public static class Builder<KType, VType>
    implements ObjectObjectMap<KType, VType> {
        private ObjectObjectHashMap<KType, VType> map;

        public Builder() {
            this(EMPTY);
        }

        public Builder(int size) {
            this.map = new ObjectObjectHashMap(size);
        }

        public Builder(ImmutableOpenMap<KType, VType> map) {
            this.map = map.map.clone();
        }

        public ImmutableOpenMap<KType, VType> build() {
            ObjectObjectHashMap<KType, VType> map = this.map;
            this.map = null;
            return new ImmutableOpenMap<KType, VType>(map);
        }

        public Builder<KType, VType> putAll(Map<KType, VType> map) {
            for (Map.Entry<KType, VType> entry : map.entrySet()) {
                this.map.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder<KType, VType> fPut(KType key, VType value) {
            this.map.put(key, value);
            return this;
        }

        @Override
        public VType put(KType key, VType value) {
            return this.map.put(key, value);
        }

        @Override
        public VType get(KType key) {
            return this.map.get(key);
        }

        @Override
        public VType getOrDefault(KType kType, VType vType) {
            return this.map.getOrDefault(kType, vType);
        }

        @Override
        public int putAll(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> container) {
            return this.map.putAll(container);
        }

        @Override
        public int putAll(Iterable<? extends ObjectObjectCursor<? extends KType, ? extends VType>> iterable) {
            return this.map.putAll(iterable);
        }

        public Builder<KType, VType> fRemove(KType key) {
            this.map.remove(key);
            return this;
        }

        @Override
        public VType remove(KType key) {
            return this.map.remove(key);
        }

        @Override
        public Iterator<ObjectObjectCursor<KType, VType>> iterator() {
            return this.map.iterator();
        }

        @Override
        public boolean containsKey(KType key) {
            return this.map.containsKey(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public int removeAll(ObjectContainer<? super KType> container) {
            return this.map.removeAll(container);
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.map.removeAll(predicate);
        }

        @Override
        public <T extends ObjectObjectProcedure<? super KType, ? super VType>> T forEach(T procedure) {
            return this.map.forEach(procedure);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public ObjectCollection<KType> keys() {
            return this.map.keys();
        }

        @Override
        public ObjectContainer<VType> values() {
            return this.map.values();
        }

        public <K, V> Builder<K, V> cast() {
            return this;
        }

        @Override
        public int removeAll(ObjectObjectPredicate<? super KType, ? super VType> predicate) {
            return this.map.removeAll(predicate);
        }

        @Override
        public <T extends ObjectObjectPredicate<? super KType, ? super VType>> T forEach(T predicate) {
            return this.map.forEach(predicate);
        }

        @Override
        public int indexOf(KType key) {
            return this.map.indexOf(key);
        }

        @Override
        public boolean indexExists(int index) {
            return this.map.indexExists(index);
        }

        @Override
        public VType indexGet(int index) {
            return this.map.indexGet(index);
        }

        @Override
        public VType indexReplace(int index, VType newValue) {
            return this.map.indexReplace(index, newValue);
        }

        @Override
        public void indexInsert(int index, KType key, VType value) {
            this.map.indexInsert(index, key, value);
        }

        @Override
        public void release() {
            this.map.release();
        }

        @Override
        public String visualizeKeyDistribution(int characters) {
            return this.map.visualizeKeyDistribution(characters);
        }
    }
}

