/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.common.SuppressLoggerChecks;
import org.elasticsearch.common.logging.DeprecatedMessage;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class DeprecationLogger {
    private final Logger logger;
    private static final CopyOnWriteArraySet<ThreadContext> THREAD_CONTEXT;
    private Set<String> keys = Collections.newSetFromMap(Collections.synchronizedMap(new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 128;
        }
    }));
    private static final String WARNING_PREFIX;
    public static final Pattern WARNING_HEADER_PATTERN;
    private static BitSet doesNotNeedEncoding;
    private static final Charset UTF_8;

    public static void setThreadContext(ThreadContext threadContext) {
        Objects.requireNonNull(threadContext, "Cannot register a null ThreadContext");
        if (!THREAD_CONTEXT.add(threadContext)) {
            throw new IllegalStateException("Double-setting ThreadContext not allowed!");
        }
    }

    public static void removeThreadContext(ThreadContext threadContext) {
        assert (threadContext != null);
        if (!THREAD_CONTEXT.remove(threadContext)) {
            throw new IllegalStateException("Removing unknown ThreadContext not allowed!");
        }
    }

    public DeprecationLogger(Logger parentLogger) {
        Object name = parentLogger.getName();
        name = ((String)name).startsWith("org.elasticsearch") ? ((String)name).replace("org.elasticsearch.", "org.elasticsearch.deprecation.") : "deprecation." + (String)name;
        this.logger = LogManager.getLogger((String)name);
    }

    public void deprecated(String msg, Object ... params) {
        this.deprecated(THREAD_CONTEXT, msg, params);
    }

    public void deprecatedAndMaybeLog(String key, String msg, Object ... params) {
        String xOpaqueId = this.getXOpaqueId(THREAD_CONTEXT);
        boolean log = this.keys.add(xOpaqueId + key);
        this.deprecated((Set<ThreadContext>)THREAD_CONTEXT, msg, log, params);
    }

    public static String extractWarningValueFromWarningHeader(String s) {
        int firstQuote = s.indexOf(34);
        int lastQuote = s.length() - 1;
        String warningValue = s.substring(firstQuote + 1, lastQuote);
        assert (DeprecationLogger.assertWarningValue(s, warningValue));
        return warningValue;
    }

    private static boolean assertWarningValue(String s, String warningValue) {
        Matcher matcher = WARNING_HEADER_PATTERN.matcher(s);
        boolean matches = matcher.matches();
        assert (matches);
        return matcher.group(1).equals(warningValue);
    }

    void deprecated(Set<ThreadContext> threadContexts, String message, Object ... params) {
        this.deprecated(threadContexts, message, true, params);
    }

    void deprecated(final Set<ThreadContext> threadContexts, final String message, boolean log, final Object ... params) {
        Iterator<ThreadContext> iterator = threadContexts.iterator();
        if (iterator.hasNext()) {
            String formattedMessage = LoggerMessageFormat.format(message, params);
            String warningHeaderValue = DeprecationLogger.formatWarning(formattedMessage);
            assert (WARNING_HEADER_PATTERN.matcher(warningHeaderValue).matches());
            assert (DeprecationLogger.extractWarningValueFromWarningHeader(warningHeaderValue).equals(DeprecationLogger.escapeAndEncode(formattedMessage)));
            while (iterator.hasNext()) {
                try {
                    ThreadContext next = iterator.next();
                    next.addResponseHeader("Warning", warningHeaderValue);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        if (log) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                @SuppressLoggerChecks(reason="safely delegates to logger")
                public Void run() {
                    String opaqueId = DeprecationLogger.this.getXOpaqueId(threadContexts);
                    DeprecationLogger.this.logger.warn((Message)new DeprecatedMessage(message, opaqueId, params));
                    return null;
                }
            });
        }
    }

    public String getXOpaqueId(Set<ThreadContext> threadContexts) {
        return threadContexts.stream().filter(t -> !t.isClosed()).filter(t -> t.getHeader("X-Opaque-Id") != null).findFirst().map(t -> t.getHeader("X-Opaque-Id")).orElse("");
    }

    public static String formatWarning(String s) {
        int length = WARNING_PREFIX.length() + s.length() + 3;
        StringBuilder sb = new StringBuilder(length);
        sb.append(WARNING_PREFIX).append(" \"").append(DeprecationLogger.escapeAndEncode(s)).append("\"");
        return sb.toString();
    }

    public static String escapeAndEncode(String s) {
        return DeprecationLogger.encode(DeprecationLogger.escapeBackslashesAndQuotes(s));
    }

    static String escapeBackslashesAndQuotes(String s) {
        boolean escapingNeeded = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"') continue;
            escapingNeeded = true;
            break;
        }
        if (escapingNeeded) {
            StringBuilder sb = new StringBuilder();
            for (char c : s.toCharArray()) {
                if (c == '\\' || c == '\"') {
                    sb.append("\\");
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return s;
    }

    static String encode(String s) {
        boolean encodingNeeded = false;
        for (int i = 0; i < s.length(); ++i) {
            char current = s.charAt(i);
            if (doesNotNeedEncoding.get(current)) continue;
            encodingNeeded = true;
            break;
        }
        if (!encodingNeeded) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char current = s.charAt(i);
            if (doesNotNeedEncoding.get(current)) {
                sb.append(current);
                ++i;
                continue;
            }
            int startIndex = i;
            while (++i < s.length() && !doesNotNeedEncoding.get(s.charAt(i))) {
            }
            byte[] bytes = s.substring(startIndex, i).getBytes(UTF_8);
            for (int j = 0; j < bytes.length; ++j) {
                sb.append('%').append(DeprecationLogger.hex(bytes[j] >> 4)).append(DeprecationLogger.hex(bytes[j]));
            }
        }
        return sb.toString();
    }

    private static char hex(int b) {
        char ch = Character.forDigit(b & 0xF, 16);
        if (Character.isLetter(ch)) {
            return Character.toUpperCase(ch);
        }
        return ch;
    }

    static {
        int i;
        THREAD_CONTEXT = new CopyOnWriteArraySet();
        WARNING_PREFIX = String.format(Locale.ROOT, "299 Elasticsearch-%s%s-%s", Version.CURRENT.toString(), Build.CURRENT.isSnapshot() ? "-SNAPSHOT" : "", Build.CURRENT.hash());
        WARNING_HEADER_PATTERN = Pattern.compile("299 Elasticsearch-\\d+\\.\\d+\\.\\d+(?:-(?:alpha|beta|rc)\\d+)?(?:-SNAPSHOT)?-(?:[a-f0-9]{7}(?:[a-f0-9]{33})?|unknown) \"((?:\t| |!|[\\x23-\\x5B]|[\\x5D-\\x7E]|[\\x80-\\xFF]|\\\\|\\\\\")*)\"( \"(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun), \\d{2} (?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4} \\d{2}:\\d{2}:\\d{2} GMT\")?");
        doesNotNeedEncoding = new BitSet(256);
        doesNotNeedEncoding.set(9);
        doesNotNeedEncoding.set(32);
        doesNotNeedEncoding.set(33);
        doesNotNeedEncoding.set(92);
        doesNotNeedEncoding.set(34);
        for (i = 35; i <= 36; ++i) {
            doesNotNeedEncoding.set(i);
        }
        for (i = 38; i <= 91; ++i) {
            doesNotNeedEncoding.set(i);
        }
        for (i = 93; i <= 126; ++i) {
            doesNotNeedEncoding.set(i);
        }
        for (i = 128; i <= 255; ++i) {
            doesNotNeedEncoding.set(i);
        }
        assert (!doesNotNeedEncoding.get(37)) : doesNotNeedEncoding;
        UTF_8 = Charset.forName("UTF-8");
    }
}

