/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public final class Fuzziness
implements ToXContentFragment,
Writeable {
    public static final String X_FIELD_NAME = "fuzziness";
    public static final Fuzziness ZERO = new Fuzziness(0);
    public static final Fuzziness ONE = new Fuzziness(1);
    public static final Fuzziness TWO = new Fuzziness(2);
    public static final Fuzziness AUTO = new Fuzziness("AUTO");
    public static final ParseField FIELD = new ParseField("fuzziness", new String[0]);
    private static final int DEFAULT_LOW_DISTANCE = 3;
    private static final int DEFAULT_HIGH_DISTANCE = 6;
    private final String fuzziness;
    private int lowDistance = 3;
    private int highDistance = 6;

    private Fuzziness(int fuzziness) {
        if (fuzziness != 0 && fuzziness != 1 && fuzziness != 2) {
            throw new IllegalArgumentException("Valid edit distances are [0, 1, 2] but was [" + fuzziness + "]");
        }
        this.fuzziness = Integer.toString(fuzziness);
    }

    private Fuzziness(String fuzziness) {
        if (fuzziness == null || fuzziness.isEmpty()) {
            throw new IllegalArgumentException("fuzziness can't be null!");
        }
        this.fuzziness = fuzziness.toUpperCase(Locale.ROOT);
    }

    private Fuzziness(String fuzziness, int lowDistance, int highDistance) {
        this(fuzziness);
        if (lowDistance < 0 || highDistance < 0 || lowDistance > highDistance) {
            throw new IllegalArgumentException("fuzziness wrongly configured, must be: lowDistance > 0, highDistance > 0 and lowDistance <= highDistance ");
        }
        this.lowDistance = lowDistance;
        this.highDistance = highDistance;
    }

    public Fuzziness(StreamInput in) throws IOException {
        this.fuzziness = in.readString();
        if (in.getVersion().onOrAfter(Version.V_6_1_0) && in.readBoolean()) {
            this.lowDistance = in.readVInt();
            this.highDistance = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fuzziness);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            if (this.isAutoWithCustomValues()) {
                out.writeBoolean(true);
                out.writeVInt(this.lowDistance);
                out.writeVInt(this.highDistance);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public static Fuzziness fromEdits(int edits) {
        return new Fuzziness(edits);
    }

    public static Fuzziness build(Object fuzziness) {
        if (fuzziness instanceof Fuzziness) {
            return (Fuzziness)fuzziness;
        }
        String string = fuzziness.toString();
        if (AUTO.asString().equalsIgnoreCase(string)) {
            return AUTO;
        }
        if (string.toUpperCase(Locale.ROOT).startsWith(AUTO.asString() + ":")) {
            return Fuzziness.parseCustomAuto(string);
        }
        return new Fuzziness(string);
    }

    private static Fuzziness parseCustomAuto(String string) {
        assert (string.toUpperCase(Locale.ROOT).startsWith(AUTO.asString() + ":"));
        String[] fuzzinessLimit = string.substring(AUTO.asString().length() + 1).split(",");
        if (fuzzinessLimit.length == 2) {
            try {
                int lowerLimit = Integer.parseInt(fuzzinessLimit[0]);
                int highLimit = Integer.parseInt(fuzzinessLimit[1]);
                return new Fuzziness("AUTO", lowerLimit, highLimit);
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchParseException("failed to parse [{}] as a \"auto:int,int\"", (Throwable)e, string);
            }
        }
        throw new ElasticsearchParseException("failed to find low and high distance values", new Object[0]);
    }

    public static Fuzziness parse(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        switch (token) {
            case VALUE_STRING: 
            case VALUE_NUMBER: {
                String fuzziness = parser.text();
                if (AUTO.asString().equalsIgnoreCase(fuzziness)) {
                    return AUTO;
                }
                if (fuzziness.toUpperCase(Locale.ROOT).startsWith(AUTO.asString() + ":")) {
                    return Fuzziness.parseCustomAuto(fuzziness);
                }
                try {
                    int minimumSimilarity = Integer.parseInt(fuzziness);
                    switch (minimumSimilarity) {
                        case 0: {
                            return ZERO;
                        }
                        case 1: {
                            return ONE;
                        }
                        case 2: {
                            return TWO;
                        }
                    }
                    return Fuzziness.build(fuzziness);
                }
                catch (NumberFormatException ex) {
                    return Fuzziness.build(fuzziness);
                }
            }
        }
        throw new IllegalArgumentException("Can't parse fuzziness on token: [" + token + "]");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(X_FIELD_NAME, this.asString());
        return builder;
    }

    public int asDistance() {
        return this.asDistance(null);
    }

    public int asDistance(String text) {
        if (this.equals(AUTO) || this.isAutoWithCustomValues()) {
            int len = this.termLen(text);
            if (len < this.lowDistance) {
                return 0;
            }
            if (len < this.highDistance) {
                return 1;
            }
            return 2;
        }
        return Math.min(2, (int)this.asFloat());
    }

    public float asFloat() {
        if (this.equals(AUTO) || this.isAutoWithCustomValues()) {
            return 1.0f;
        }
        return Float.parseFloat(this.fuzziness.toString());
    }

    private int termLen(String text) {
        return text == null ? 5 : text.codePointCount(0, text.length());
    }

    public String asString() {
        if (this.isAutoWithCustomValues()) {
            return this.fuzziness.toString() + ":" + this.lowDistance + "," + this.highDistance;
        }
        return this.fuzziness.toString();
    }

    private boolean isAutoWithCustomValues() {
        return this.fuzziness.startsWith("AUTO") && (this.lowDistance != 3 || this.highDistance != 6);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Fuzziness other = (Fuzziness)obj;
        return Objects.equals(this.fuzziness, other.fuzziness) && this.lowDistance == other.lowDistance && this.highDistance == other.highDistance;
    }

    public int hashCode() {
        return Objects.hash(this.fuzziness, this.lowDistance, this.highDistance);
    }
}

