/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;

public final class ConstructingObjectParser<Value, Context>
extends AbstractObjectParser<Value, Context> {
    private static final BiConsumer<?, ?> REQUIRED_CONSTRUCTOR_ARG_MARKER = (a, b) -> {
        throw new UnsupportedOperationException("I am just a marker I should never be called.");
    };
    private static final BiConsumer<?, ?> OPTIONAL_CONSTRUCTOR_ARG_MARKER = (a, b) -> {
        throw new UnsupportedOperationException("I am just a marker I should never be called.");
    };
    private final List<ConstructorArgInfo> constructorArgInfos = new ArrayList<ConstructorArgInfo>();
    private final ObjectParser<Target, Context> objectParser;
    private final BiFunction<Object[], Context, Value> builder;
    private int numberOfFields = 0;

    public ConstructingObjectParser(String name, Function<Object[], Value> builder) {
        this(name, false, builder);
    }

    public ConstructingObjectParser(String name, boolean ignoreUnknownFields, Function<Object[], Value> builder) {
        this(name, ignoreUnknownFields, (Object[] args, Context context) -> builder.apply((Object[])args));
    }

    public ConstructingObjectParser(String name, boolean ignoreUnknownFields, BiFunction<Object[], Context, Value> builder) {
        this.objectParser = new ObjectParser(name, ignoreUnknownFields, null);
        this.builder = builder;
    }

    @Override
    public Value apply(XContentParser parser, Context context) {
        try {
            return this.parse(parser, context);
        }
        catch (IOException e) {
            throw new XContentParseException(parser.getTokenLocation(), "[" + this.objectParser.getName() + "] failed to parse object", e);
        }
    }

    @Override
    public Value parse(XContentParser parser, Context context) throws IOException {
        return this.objectParser.parse(parser, new Target(parser, context), context).finish();
    }

    public static <Value, FieldT> BiConsumer<Value, FieldT> constructorArg() {
        return REQUIRED_CONSTRUCTOR_ARG_MARKER;
    }

    public static <Value, FieldT> BiConsumer<Value, FieldT> optionalConstructorArg() {
        return OPTIONAL_CONSTRUCTOR_ARG_MARKER;
    }

    @Override
    public <T> void declareField(BiConsumer<Value, T> consumer, ContextParser<Context, T> parser, ParseField parseField, ObjectParser.ValueType type) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (parser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        if (parseField == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (type == null) {
            throw new IllegalArgumentException("[type] is required");
        }
        if (consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER || consumer == OPTIONAL_CONSTRUCTOR_ARG_MARKER) {
            int position = this.constructorArgInfos.size();
            boolean required = consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER;
            this.constructorArgInfos.add(new ConstructorArgInfo(parseField, required));
            this.objectParser.declareField((Value target, T v) -> target.constructorArg(position, v), parser, parseField, type);
        } else {
            ++this.numberOfFields;
            this.objectParser.declareField(this.queueingConsumer(consumer, parseField), parser, parseField, type);
        }
    }

    @Override
    public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, ObjectParser.NamedObjectParser<T, Context> namedObjectParser, ParseField parseField) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (namedObjectParser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        if (parseField == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER || consumer == OPTIONAL_CONSTRUCTOR_ARG_MARKER) {
            int position = this.constructorArgInfos.size();
            boolean required = consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER;
            this.constructorArgInfos.add(new ConstructorArgInfo(parseField, required));
            this.objectParser.declareNamedObjects((target, v) -> target.constructorArg(position, v), namedObjectParser, parseField);
        } else {
            ++this.numberOfFields;
            this.objectParser.declareNamedObjects(this.queueingConsumer(consumer, parseField), namedObjectParser, parseField);
        }
    }

    @Override
    public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, ObjectParser.NamedObjectParser<T, Context> namedObjectParser, Consumer<Value> orderedModeCallback, ParseField parseField) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (namedObjectParser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        if (orderedModeCallback == null) {
            throw new IllegalArgumentException("[orderedModeCallback] is required");
        }
        if (parseField == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER || consumer == OPTIONAL_CONSTRUCTOR_ARG_MARKER) {
            int position = this.constructorArgInfos.size();
            boolean required = consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER;
            this.constructorArgInfos.add(new ConstructorArgInfo(parseField, required));
            this.objectParser.declareNamedObjects((target, v) -> target.constructorArg(position, v), namedObjectParser, this.wrapOrderedModeCallBack(orderedModeCallback), parseField);
        } else {
            ++this.numberOfFields;
            this.objectParser.declareNamedObjects(this.queueingConsumer(consumer, parseField), namedObjectParser, this.wrapOrderedModeCallBack(orderedModeCallback), parseField);
        }
    }

    @Override
    public String getName() {
        return this.objectParser.getName();
    }

    private Consumer<Target> wrapOrderedModeCallBack(Consumer<Value> callback) {
        return target -> {
            if (target.targetObject != null) {
                callback.accept(target.targetObject);
                return;
            }
            target.queuedOrderedModeCallback = callback;
        };
    }

    private <T> BiConsumer<Target, T> queueingConsumer(BiConsumer<Value, T> consumer, ParseField parseField) {
        return (target, v) -> {
            if (target.targetObject != null) {
                consumer.accept(target.targetObject, v);
                return;
            }
            XContentLocation location = target.parser.getTokenLocation();
            target.queue(targetObject -> {
                try {
                    consumer.accept(targetObject, v);
                }
                catch (Exception e) {
                    throw new XContentParseException(location, "[" + this.objectParser.getName() + "] failed to parse field [" + parseField.getPreferredName() + "]", e);
                }
            });
        };
    }

    private static class ConstructorArgInfo {
        final ParseField field;
        final boolean required;

        ConstructorArgInfo(ParseField field, boolean required) {
            this.field = field;
            this.required = required;
        }
    }

    private class Target {
        private final Object[] constructorArgs;
        private final XContentParser parser;
        private Context context;
        private int constructorArgsCollected;
        private Consumer<Value>[] queuedFields;
        private Consumer<Value> queuedOrderedModeCallback;
        private int queuedFieldsCount;
        private Value targetObject;

        Target(XContentParser parser, Context context) {
            this.constructorArgs = new Object[ConstructingObjectParser.this.constructorArgInfos.size()];
            this.constructorArgsCollected = 0;
            this.queuedFieldsCount = 0;
            this.parser = parser;
            this.context = context;
        }

        private void constructorArg(int position, Object value) {
            this.constructorArgs[position] = value;
            ++this.constructorArgsCollected;
            if (this.constructorArgsCollected == ConstructingObjectParser.this.constructorArgInfos.size()) {
                this.buildTarget();
            }
        }

        private void queue(Consumer<Value> queueMe) {
            assert (this.targetObject == null) : "Don't queue after the targetObject has been built! Just apply the consumer directly.";
            if (this.queuedFields == null) {
                Consumer[] queuedFields = new Consumer[ConstructingObjectParser.this.numberOfFields];
                this.queuedFields = queuedFields;
            }
            this.queuedFields[this.queuedFieldsCount] = queueMe;
            ++this.queuedFieldsCount;
        }

        private Value finish() {
            if (this.targetObject != null) {
                return this.targetObject;
            }
            StringBuilder message = null;
            for (int i = 0; i < this.constructorArgs.length; ++i) {
                if (this.constructorArgs[i] != null) continue;
                ConstructorArgInfo arg = ConstructingObjectParser.this.constructorArgInfos.get(i);
                if (!arg.required) continue;
                if (message == null) {
                    message = new StringBuilder("Required [").append(arg.field);
                    continue;
                }
                message.append(", ").append(arg.field);
            }
            if (message != null) {
                throw new IllegalArgumentException(message.append(']').toString());
            }
            assert (!ConstructingObjectParser.this.constructorArgInfos.isEmpty()) : "[" + ConstructingObjectParser.this.objectParser.getName() + "] must configure at least one constructor argument. If it doesn't have any it should use ObjectParser instead of ConstructingObjectParser. This is a bug in the parser declaration.";
            this.buildTarget();
            return this.targetObject;
        }

        private void buildTarget() {
            try {
                this.targetObject = ConstructingObjectParser.this.builder.apply(this.constructorArgs, this.context);
                if (this.queuedOrderedModeCallback != null) {
                    this.queuedOrderedModeCallback.accept(this.targetObject);
                }
                while (this.queuedFieldsCount > 0) {
                    --this.queuedFieldsCount;
                    this.queuedFields[this.queuedFieldsCount].accept(this.targetObject);
                }
            }
            catch (XContentParseException e) {
                throw new XContentParseException(e.getLocation(), "failed to build [" + ConstructingObjectParser.this.objectParser.getName() + "] after last required field arrived", e);
            }
            catch (Exception e) {
                throw new XContentParseException(null, "Failed to build [" + ConstructingObjectParser.this.objectParser.getName() + "] after last required field arrived", e);
            }
        }
    }
}

