/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.InMemoryPersistedState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.IncrementalClusterStateWriter;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;
import org.elasticsearch.plugins.MetaDataUpgrader;
import org.elasticsearch.transport.TransportService;

public class GatewayMetaState {
    private static final Logger logger = LogManager.getLogger(GatewayMetaState.class);
    private final SetOnce<CoordinationState.PersistedState> persistedState = new SetOnce();

    public CoordinationState.PersistedState getPersistedState() {
        CoordinationState.PersistedState persistedState = this.persistedState.get();
        assert (persistedState != null) : "not started";
        return persistedState;
    }

    public MetaData getMetaData() {
        return this.getPersistedState().getLastAcceptedState().metaData();
    }

    public void start(Settings settings, TransportService transportService, ClusterService clusterService, MetaStateService metaStateService, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) {
        Tuple<Manifest, ClusterState> manifestClusterStateTuple;
        assert (this.persistedState.get() == null) : "should only start once, but already have " + this.persistedState.get();
        try {
            this.upgradeMetaData(settings, metaStateService, metaDataIndexUpgradeService, metaDataUpgrader);
            manifestClusterStateTuple = GatewayMetaState.loadStateAndManifest(ClusterName.CLUSTER_NAME_SETTING.get(settings), metaStateService);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to load metadata", (Throwable)e, new Object[0]);
        }
        IncrementalClusterStateWriter incrementalClusterStateWriter = new IncrementalClusterStateWriter(settings, clusterService.getClusterSettings(), metaStateService, manifestClusterStateTuple.v1(), this.prepareInitialClusterState(transportService, clusterService, manifestClusterStateTuple.v2()), transportService.getThreadPool()::relativeTimeInMillis);
        if (DiscoveryModule.DISCOVERY_TYPE_SETTING.get(settings).equals("legacy-zen")) {
            if (GatewayMetaState.isMasterOrDataNode(settings)) {
                clusterService.addLowPriorityApplier(new GatewayClusterApplier(incrementalClusterStateWriter));
            }
            this.persistedState.set(new InMemoryPersistedState(manifestClusterStateTuple.v1().getCurrentTerm(), manifestClusterStateTuple.v2()));
        } else if (!DiscoveryNode.isMasterNode(settings)) {
            if (DiscoveryNode.isDataNode(settings)) {
                clusterService.addLowPriorityApplier(new GatewayClusterApplier(incrementalClusterStateWriter));
            }
            this.persistedState.set(new InMemoryPersistedState(manifestClusterStateTuple.v1().getCurrentTerm(), manifestClusterStateTuple.v2()));
        } else {
            this.persistedState.set(new GatewayPersistedState(incrementalClusterStateWriter));
        }
    }

    ClusterState prepareInitialClusterState(TransportService transportService, ClusterService clusterService, ClusterState clusterState) {
        assert (clusterState.nodes().getLocalNode() == null) : "prepareInitialClusterState must only be called once";
        assert (transportService.getLocalNode() != null) : "transport service is not yet started";
        return Function.identity().andThen(ClusterStateUpdaters::addStateNotRecoveredBlock).andThen(state -> ClusterStateUpdaters.setLocalNode(state, transportService.getLocalNode())).andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, clusterService.getClusterSettings())).andThen(ClusterStateUpdaters::recoverClusterBlocks).apply(clusterState);
    }

    void upgradeMetaData(Settings settings, MetaStateService metaStateService, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) throws IOException {
        if (GatewayMetaState.isMasterOrDataNode(settings)) {
            try {
                Tuple<Manifest, MetaData> metaStateAndData = metaStateService.loadFullState();
                Manifest manifest = metaStateAndData.v1();
                MetaData metaData = metaStateAndData.v2();
                IncrementalClusterStateWriter.AtomicClusterStateWriter writer = new IncrementalClusterStateWriter.AtomicClusterStateWriter(metaStateService, manifest);
                MetaData upgradedMetaData = GatewayMetaState.upgradeMetaData(metaData, metaDataIndexUpgradeService, metaDataUpgrader);
                long globalStateGeneration = !MetaData.isGlobalStateEquals(metaData, upgradedMetaData) ? writer.writeGlobalState("upgrade", upgradedMetaData) : manifest.getGlobalGeneration();
                HashMap<Index, Long> indices = new HashMap<Index, Long>(manifest.getIndexGenerations());
                for (IndexMetaData indexMetaData : upgradedMetaData) {
                    if (metaData.hasIndexMetaData(indexMetaData)) continue;
                    long generation = writer.writeIndex("upgrade", indexMetaData);
                    indices.put(indexMetaData.getIndex(), generation);
                }
                Manifest newManifest = new Manifest(manifest.getCurrentTerm(), manifest.getClusterStateVersion(), globalStateGeneration, indices);
                writer.writeManifestAndCleanup("startup", newManifest);
            }
            catch (Exception e) {
                logger.error("failed to read or upgrade local state, exiting...", (Throwable)e);
                throw e;
            }
        }
    }

    private static Tuple<Manifest, ClusterState> loadStateAndManifest(ClusterName clusterName, MetaStateService metaStateService) throws IOException {
        long startNS = System.nanoTime();
        Tuple<Manifest, MetaData> manifestAndMetaData = metaStateService.loadFullState();
        Manifest manifest = manifestAndMetaData.v1();
        ClusterState clusterState = ClusterState.builder(clusterName).version(manifest.getClusterStateVersion()).metaData(manifestAndMetaData.v2()).build();
        logger.debug("took {} to load state", (Object)TimeValue.timeValueMillis(TimeValue.nsecToMSec(System.nanoTime() - startNS)));
        return Tuple.tuple(manifest, clusterState);
    }

    private static boolean isMasterOrDataNode(Settings settings) {
        return DiscoveryNode.isMasterNode(settings) || DiscoveryNode.isDataNode(settings);
    }

    static MetaData upgradeMetaData(MetaData metaData, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) {
        boolean changed = false;
        MetaData.Builder upgradedMetaData = MetaData.builder(metaData);
        for (IndexMetaData indexMetaData : metaData) {
            IndexMetaData newMetaData;
            changed |= indexMetaData != (newMetaData = metaDataIndexUpgradeService.upgradeIndexMetaData(indexMetaData, Version.CURRENT.minimumIndexCompatibilityVersion()));
            upgradedMetaData.put(newMetaData, false);
        }
        if (GatewayMetaState.applyPluginUpgraders(metaData.getTemplates(), metaDataUpgrader.indexTemplateMetaDataUpgraders, upgradedMetaData::removeTemplate, (s, indexTemplateMetaData) -> upgradedMetaData.put((IndexTemplateMetaData)indexTemplateMetaData))) {
            changed = true;
        }
        return changed ? upgradedMetaData.build() : metaData;
    }

    private static boolean applyPluginUpgraders(ImmutableOpenMap<String, IndexTemplateMetaData> existingData, UnaryOperator<Map<String, IndexTemplateMetaData>> upgrader, Consumer<String> removeData, BiConsumer<String, IndexTemplateMetaData> putData) {
        HashMap<String, IndexTemplateMetaData> existingMap = new HashMap<String, IndexTemplateMetaData>();
        for (ObjectObjectCursor<String, IndexTemplateMetaData> objectObjectCursor : existingData) {
            existingMap.put((String)objectObjectCursor.key, (IndexTemplateMetaData)objectObjectCursor.value);
        }
        Map upgradedCustoms = (Map)upgrader.apply(existingMap);
        if (!upgradedCustoms.equals(existingMap)) {
            existingMap.keySet().forEach(removeData);
            for (Map.Entry upgradedCustomEntry : upgradedCustoms.entrySet()) {
                putData.accept((String)upgradedCustomEntry.getKey(), (IndexTemplateMetaData)upgradedCustomEntry.getValue());
            }
            return true;
        }
        return false;
    }

    private static class GatewayPersistedState
    implements CoordinationState.PersistedState {
        private final IncrementalClusterStateWriter incrementalClusterStateWriter;

        GatewayPersistedState(IncrementalClusterStateWriter incrementalClusterStateWriter) {
            this.incrementalClusterStateWriter = incrementalClusterStateWriter;
        }

        @Override
        public long getCurrentTerm() {
            return this.incrementalClusterStateWriter.getPreviousManifest().getCurrentTerm();
        }

        @Override
        public ClusterState getLastAcceptedState() {
            ClusterState previousClusterState = this.incrementalClusterStateWriter.getPreviousClusterState();
            assert (previousClusterState.nodes().getLocalNode() != null) : "Cluster state is not fully built yet";
            return previousClusterState;
        }

        @Override
        public void setCurrentTerm(long currentTerm) {
            try {
                this.incrementalClusterStateWriter.setCurrentTerm(currentTerm);
            }
            catch (WriteStateException e) {
                logger.error((Message)new ParameterizedMessage("Failed to set current term to {}", (Object)currentTerm), (Throwable)e);
                e.rethrowAsErrorOrUncheckedException();
            }
        }

        @Override
        public void setLastAcceptedState(ClusterState clusterState) {
            try {
                this.incrementalClusterStateWriter.setIncrementalWrite(this.incrementalClusterStateWriter.getPreviousClusterState().term() == clusterState.term());
                this.incrementalClusterStateWriter.updateClusterState(clusterState);
            }
            catch (WriteStateException e) {
                logger.error((Message)new ParameterizedMessage("Failed to set last accepted state with version {}", (Object)clusterState.version()), (Throwable)e);
                e.rethrowAsErrorOrUncheckedException();
            }
        }
    }

    private static class GatewayClusterApplier
    implements ClusterStateApplier {
        private final IncrementalClusterStateWriter incrementalClusterStateWriter;

        private GatewayClusterApplier(IncrementalClusterStateWriter incrementalClusterStateWriter) {
            this.incrementalClusterStateWriter = incrementalClusterStateWriter;
        }

        @Override
        public void applyClusterState(ClusterChangedEvent event) {
            if (event.state().blocks().disableStatePersistence()) {
                this.incrementalClusterStateWriter.setIncrementalWrite(false);
                return;
            }
            try {
                if (event.state().term() > this.incrementalClusterStateWriter.getPreviousManifest().getCurrentTerm()) {
                    this.incrementalClusterStateWriter.setCurrentTerm(event.state().term());
                }
                this.incrementalClusterStateWriter.updateClusterState(event.state());
                this.incrementalClusterStateWriter.setIncrementalWrite(true);
            }
            catch (WriteStateException e) {
                logger.warn("Exception occurred when storing new meta data", (Throwable)e);
            }
        }
    }
}

