/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.query.VectorGeoShapeQueryProcessor;

public class GeoShapeFieldMapper
extends AbstractGeometryFieldMapper<Geometry, Geometry> {
    public static final String CONTENT_TYPE = "geo_shape";

    public GeoShapeFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, ignoreZValue, indexSettings, multiFields, copyTo);
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        if (mergeWith instanceof LegacyGeoShapeFieldMapper) {
            LegacyGeoShapeFieldMapper legacy = (LegacyGeoShapeFieldMapper)mergeWith;
            throw new IllegalArgumentException("[" + this.fieldType().name() + "] with field mapper [" + this.fieldType().typeName() + "] using [BKD] strategy cannot be merged with [" + legacy.fieldType().typeName() + "] with [" + legacy.fieldType().strategy() + "] strategy");
        }
        super.doMerge(mergeWith);
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class GeoShapeFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType<Geometry, Geometry> {
        public GeoShapeFieldType() {
        }

        protected GeoShapeFieldType(GeoShapeFieldType ref) {
            super(ref);
        }

        @Override
        public GeoShapeFieldType clone() {
            return new GeoShapeFieldType(this);
        }

        @Override
        public String typeName() {
            return GeoShapeFieldMapper.CONTENT_TYPE;
        }
    }

    public static class Builder
    extends AbstractGeometryFieldMapper.Builder<AbstractGeometryFieldMapper.Builder, GeoShapeFieldMapper> {
        public Builder(String name) {
            super(name, new GeoShapeFieldType(), new GeoShapeFieldType());
        }

        @Override
        public GeoShapeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new GeoShapeFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.ignoreZValue(), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            GeoShapeFieldType fieldType = (GeoShapeFieldType)this.fieldType();
            boolean orientation = fieldType.orientation == ShapeBuilder.Orientation.RIGHT;
            GeometryParser geometryParser = new GeometryParser(orientation, this.coerce(context).value(), this.ignoreZValue().value());
            fieldType.setGeometryIndexer(new GeoShapeIndexer(orientation, fieldType.name()));
            fieldType.setGeometryParser((parser, mapper) -> geometryParser.parse(parser));
            fieldType.setGeometryQueryBuilder(new VectorGeoShapeQueryProcessor());
        }
    }
}

