/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.seqno.RetentionLeaseSyncAction;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class RetentionLeaseBackgroundSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static String ACTION_NAME = "indices:admin/seq_no/retention_lease_background_sync";
    private static final Logger LOGGER = LogManager.getLogger(RetentionLeaseSyncAction.class);

    protected Logger getLogger() {
        return LOGGER;
    }

    @Inject
    public RetentionLeaseBackgroundSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, Request::new, Request::new, "management");
    }

    public void backgroundSync(ShardId shardId, RetentionLeases retentionLeases) {
        Objects.requireNonNull(shardId);
        Objects.requireNonNull(retentionLeases);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            this.execute(new Request(shardId, retentionLeases), ActionListener.wrap(r -> {}, e -> {
                if (ExceptionsHelper.isTransportStoppedForAction(e, ACTION_NAME + "[p]")) {
                    return;
                }
                if (ExceptionsHelper.unwrap(e, AlreadyClosedException.class, IndexShardClosedException.class) != null) {
                    return;
                }
                this.getLogger().warn((Message)new ParameterizedMessage("{} retention lease background sync failed", (Object)shardId), (Throwable)e);
            }));
        }
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            assert (request.waitForActiveShards().equals(ActiveShardCount.NONE)) : request.waitForActiveShards();
            Objects.requireNonNull(request);
            Objects.requireNonNull(primary);
            primary.persistRetentionLeases();
            return new TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse());
        });
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(Request request, IndexShard replica) throws WriteStateException {
        Objects.requireNonNull(request);
        Objects.requireNonNull(replica);
        replica.updateRetentionLeasesOnReplica(request.getRetentionLeases());
        replica.persistRetentionLeases();
        return new TransportReplicationAction.ReplicaResult();
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private RetentionLeases retentionLeases;

        public RetentionLeases getRetentionLeases() {
            return this.retentionLeases;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.retentionLeases = new RetentionLeases(in);
        }

        public Request(ShardId shardId, RetentionLeases retentionLeases) {
            super(Objects.requireNonNull(shardId));
            this.retentionLeases = Objects.requireNonNull(retentionLeases);
            this.waitForActiveShards(ActiveShardCount.NONE);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(Objects.requireNonNull(out));
            this.retentionLeases.writeTo(out);
        }

        @Override
        public String toString() {
            return "RetentionLeaseBackgroundSyncAction.Request{retentionLeases=" + this.retentionLeases + ", shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + "', waitForActiveShards=" + this.waitForActiveShards + "}";
        }
    }
}

