/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.bucket.MergingBucketsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalAutoDateHistogram;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

class AutoDateHistogramAggregator
extends DeferableBucketAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;
    private int roundingIdx = 0;
    private LongHash bucketOrds;
    private int targetBuckets;
    private MergingBucketsDeferringCollector deferringCollector;

    AutoDateHistogramAggregator(String name, AggregatorFactories factories, int numBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, @Nullable ValuesSource.Numeric valuesSource, DocValueFormat formatter, SearchContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        this.targetBuckets = numBuckets;
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        this.roundingInfos = roundingInfos;
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.deferringCollector = new MergingBucketsDeferringCollector(this.context, AutoDateHistogramAggregator.descendsFromGlobalAggregator(this.parent()));
        return this.deferringCollector;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = AutoDateHistogramAggregator.this.roundingInfos[AutoDateHistogramAggregator.this.roundingIdx].rounding.round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        long bucketOrd = AutoDateHistogramAggregator.this.bucketOrds.add(rounded);
                        if (bucketOrd < 0L) {
                            bucketOrd = -1L - bucketOrd;
                            AutoDateHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                        } else {
                            AutoDateHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                            while (AutoDateHistogramAggregator.this.roundingIdx < AutoDateHistogramAggregator.this.roundingInfos.length - 1 && AutoDateHistogramAggregator.this.bucketOrds.size() > (long)(AutoDateHistogramAggregator.this.targetBuckets * AutoDateHistogramAggregator.this.roundingInfos[AutoDateHistogramAggregator.this.roundingIdx].getMaximumInnerInterval())) {
                                this.increaseRounding();
                            }
                        }
                        previousRounded = rounded;
                    }
                }
            }

            private void increaseRounding() {
                try (LongHash oldBucketOrds = AutoDateHistogramAggregator.this.bucketOrds;){
                    LongHash newBucketOrds = new LongHash(1L, AutoDateHistogramAggregator.this.context.bigArrays());
                    long[] mergeMap = new long[(int)oldBucketOrds.size()];
                    Rounding newRounding = AutoDateHistogramAggregator.this.roundingInfos[++AutoDateHistogramAggregator.this.roundingIdx].rounding;
                    int i = 0;
                    while ((long)i < oldBucketOrds.size()) {
                        long oldKey = oldBucketOrds.get(i);
                        long newKey = newRounding.round(oldKey);
                        long newBucketOrd = newBucketOrds.add(newKey);
                        mergeMap[i] = newBucketOrd >= 0L ? newBucketOrd : -1L - newBucketOrd;
                        ++i;
                    }
                    AutoDateHistogramAggregator.this.mergeBuckets(mergeMap, newBucketOrds.size());
                    if (AutoDateHistogramAggregator.this.deferringCollector != null) {
                        AutoDateHistogramAggregator.this.deferringCollector.mergeBuckets(mergeMap);
                    }
                    AutoDateHistogramAggregator.this.bucketOrds = newBucketOrds;
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        this.consumeBucketsAndMaybeBreak((int)this.bucketOrds.size());
        long[] bucketOrdArray = new long[(int)this.bucketOrds.size()];
        int i = 0;
        while ((long)i < this.bucketOrds.size()) {
            bucketOrdArray[i] = i;
            ++i;
        }
        this.runDeferredCollections(bucketOrdArray);
        ArrayList<InternalAutoDateHistogram.Bucket> buckets = new ArrayList<InternalAutoDateHistogram.Bucket>((int)this.bucketOrds.size());
        for (long i2 = 0L; i2 < this.bucketOrds.size(); ++i2) {
            buckets.add(new InternalAutoDateHistogram.Bucket(this.bucketOrds.get(i2), this.bucketDocCount(i2), this.formatter, this.bucketAggregations(i2)));
        }
        CollectionUtil.introSort(buckets, BucketOrder.key(true).comparator(this));
        InternalAutoDateHistogram.BucketInfo emptyBucketInfo = new InternalAutoDateHistogram.BucketInfo(this.roundingInfos, this.roundingIdx, this.buildEmptySubAggregations());
        return new InternalAutoDateHistogram(this.name, buckets, this.targetBuckets, emptyBucketInfo, this.formatter, this.pipelineAggregators(), this.metaData(), 1L);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAutoDateHistogram.BucketInfo emptyBucketInfo = new InternalAutoDateHistogram.BucketInfo(this.roundingInfos, this.roundingIdx, this.buildEmptySubAggregations());
        return new InternalAutoDateHistogram(this.name, Collections.emptyList(), this.targetBuckets, emptyBucketInfo, this.formatter, this.pipelineAggregators(), this.metaData(), 1L);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

