/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.impl;

import java.util.Formatter;
import java.util.Locale;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.CircleImpl;

public class GeoCircle
extends CircleImpl {
    private GeoCircle inverseCircle;
    private double horizAxisY;

    public GeoCircle(Point p, double radiusDEG, SpatialContext ctx) {
        super(p, radiusDEG, ctx);
        assert (ctx.isGeo());
        this.init();
    }

    @Override
    public void reset(double x, double y, double radiusDEG) {
        super.reset(x, y, radiusDEG);
        this.init();
    }

    private void init() {
        if (this.radiusDEG > 90.0) {
            assert (this.enclosingBox.getWidth() == 360.0);
            double backDistDEG = 180.0 - this.radiusDEG;
            if (backDistDEG > 0.0) {
                double backRadius = 180.0 - this.radiusDEG;
                double backX = DistanceUtils.normLonDEG(this.getCenter().getX() + 180.0);
                double backY = DistanceUtils.normLatDEG(this.getCenter().getY() + 180.0);
                backRadius -= Math.max(Math.ulp(Math.abs(backY) + backRadius), Math.ulp(Math.abs(backX) + backRadius));
                if (this.inverseCircle != null) {
                    this.inverseCircle.reset(backX, backY, backRadius);
                } else {
                    this.inverseCircle = new GeoCircle(this.ctx.makePoint(backX, backY), backRadius, this.ctx);
                }
            } else {
                this.inverseCircle = null;
            }
            this.horizAxisY = this.getCenter().getY();
        } else {
            this.inverseCircle = null;
            double _horizAxisY = this.ctx.getDistCalc().calcBoxByDistFromPt_yHorizAxisDEG(this.getCenter(), this.radiusDEG, this.ctx);
            this.horizAxisY = _horizAxisY > this.enclosingBox.getMaxY() ? this.enclosingBox.getMaxY() : (_horizAxisY < this.enclosingBox.getMinY() ? this.enclosingBox.getMinY() : _horizAxisY);
        }
    }

    @Override
    protected double getYAxis() {
        return this.horizAxisY;
    }

    @Override
    protected SpatialRelation relateRectanglePhase2(Rectangle r, SpatialRelation bboxSect) {
        if (this.inverseCircle != null) {
            return this.inverseCircle.relate(r).inverse();
        }
        if (this.enclosingBox.getWidth() == 360.0) {
            return this.relateRectangleCircleWrapsPole(r, this.ctx);
        }
        if (!this.enclosingBox.getCrossesDateLine() && !r.getCrossesDateLine()) {
            return super.relateRectanglePhase2(r, bboxSect);
        }
        if (r.getWidth() == 360.0) {
            return SpatialRelation.INTERSECTS;
        }
        int cornersIntersect = this.numCornersIntersect(r);
        if (cornersIntersect == 4) {
            SpatialRelation xIntersect = r.relateXRange(this.enclosingBox.getMinX(), this.enclosingBox.getMaxX());
            if (xIntersect == SpatialRelation.WITHIN) {
                return SpatialRelation.CONTAINS;
            }
            return SpatialRelation.INTERSECTS;
        }
        if (cornersIntersect > 0) {
            return SpatialRelation.INTERSECTS;
        }
        if (r.relateYRange(this.getYAxis(), this.getYAxis()).intersects() && r.relateXRange(this.enclosingBox.getMinX(), this.enclosingBox.getMaxX()).intersects()) {
            return SpatialRelation.INTERSECTS;
        }
        if (r.relateXRange(this.getXAxis(), this.getXAxis()).intersects()) {
            double yTop = this.getCenter().getY() + this.radiusDEG;
            assert (yTop <= 90.0);
            double yBot = this.getCenter().getY() - this.radiusDEG;
            assert (yBot >= -90.0);
            if (r.relateYRange(yBot, yTop).intersects()) {
                return SpatialRelation.INTERSECTS;
            }
        }
        return SpatialRelation.DISJOINT;
    }

    private SpatialRelation relateRectangleCircleWrapsPole(Rectangle r, SpatialContext ctx) {
        if (this.radiusDEG == 180.0) {
            return SpatialRelation.CONTAINS;
        }
        double yTop = this.getCenter().getY() + this.radiusDEG;
        if (yTop > 90.0) {
            double yTopOverlap = yTop - 90.0;
            assert (yTopOverlap <= 90.0);
            if (r.getMinY() >= 90.0 - yTopOverlap) {
                return SpatialRelation.CONTAINS;
            }
        } else {
            double yBot = this.point.getY() - this.radiusDEG;
            if (yBot < -90.0) {
                double yBotOverlap = -90.0 - yBot;
                assert (yBotOverlap <= 90.0);
                if (r.getMaxY() <= -90.0 + yBotOverlap) {
                    return SpatialRelation.CONTAINS;
                }
            } else assert (yTop == 90.0 || yBot == -90.0);
        }
        if (r.getWidth() == 360.0) {
            return SpatialRelation.INTERSECTS;
        }
        int cornersIntersect = this.numCornersIntersect(r);
        double frontX = this.getCenter().getX();
        if (cornersIntersect == 4) {
            double backX;
            double d = backX = frontX <= 0.0 ? frontX + 180.0 : frontX - 180.0;
            if (r.relateXRange(backX, backX).intersects()) {
                return SpatialRelation.INTERSECTS;
            }
            return SpatialRelation.CONTAINS;
        }
        if (cornersIntersect == 0) {
            if (r.relateXRange(frontX, frontX).intersects()) {
                return SpatialRelation.INTERSECTS;
            }
            return SpatialRelation.DISJOINT;
        }
        return SpatialRelation.INTERSECTS;
    }

    private int numCornersIntersect(Rectangle r) {
        boolean bool = this.contains(r.getMinX(), r.getMinY());
        if (this.contains(r.getMinX(), r.getMaxY()) ? !bool : bool) {
            return 1;
        }
        if (this.contains(r.getMaxX(), r.getMinY()) ? !bool : bool) {
            return 1;
        }
        if (this.contains(r.getMaxX(), r.getMaxY()) ? !bool : bool) {
            return 1;
        }
        return bool ? 4 : 0;
    }

    @Override
    public String toString() {
        double distKm = DistanceUtils.degrees2Dist(this.radiusDEG, 6371.0087714);
        String dStr = new Formatter(Locale.ROOT).format("%.1f\u00b0 %.2fkm", this.radiusDEG, distKm).toString();
        return "Circle(" + this.point + ", d=" + dStr + ")";
    }
}

