/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscCompoundQueueL0Pad;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;

abstract class MpscCompoundQueueColdFields<E>
extends MpscCompoundQueueL0Pad<E> {
    protected final int parallelQueues;
    protected final int parallelQueuesMask;
    protected final MpscArrayQueue<E>[] queues;

    public MpscCompoundQueueColdFields(int capacity, int queueParallelism) {
        this.parallelQueues = Pow2.isPowerOfTwo(queueParallelism) ? queueParallelism : Pow2.roundToPowerOfTwo(queueParallelism) / 2;
        this.parallelQueuesMask = this.parallelQueues - 1;
        this.queues = new MpscArrayQueue[this.parallelQueues];
        int fullCapacity = Pow2.roundToPowerOfTwo(capacity);
        RangeUtil.checkGreaterThanOrEqual(fullCapacity, this.parallelQueues, "fullCapacity");
        for (int i = 0; i < this.parallelQueues; ++i) {
            this.queues[i] = new MpscArrayQueue(fullCapacity / this.parallelQueues);
        }
    }
}

